# SDOHCC Observation Response NHANES Question 6 Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Response NHANES Question 6 Example

Language: en

Profile: [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)

**status**: Final

**category**: Survey, SDOH, Social Connection

**code**: Social isolation score [NHANES]

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**effective**: 2020-09-10 21:56:54+0000

**issued**: 2020-09-10 21:56:54+0000

**performer**: [Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)

**value**: 4 {Number}

**derivedFrom**: 

* [Observation Marital status [NHANES]](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md)
* [Observation In a typical week, how many times do you talk on the telephone with family, friends, or neighbors [NHANES III]](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md)
* [Observation How often do you get together with friends or relatives [NHANES III]](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md)
* [Observation How often do you attend church or religious services [NHANES]](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md)
* [Observation Do you belong to any clubs or organizations such as church groups unions, fraternal or athletic groups, or school groups [NHANES III]](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationResponseNHANESQuestion6Example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "social-connection",
          "display" : "Social Connection"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "76512-3",
        "display" : "Social isolation score [NHANES]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "effectiveDateTime" : "2020-09-10T21:56:54.671Z",
  "issued" : "2020-09-10T21:56:54.671Z",
  "performer" : [
    {
      "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample",
      "display" : "Dr Jan Water"
    }
  ],
  "valueQuantity" : {
    "value" : 4,
    "unit" : "{Number}"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion1Example"
    },
    {
      "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion2Example"
    },
    {
      "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion3Example"
    },
    {
      "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion4Example"
    },
    {
      "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion5Example"
    }
  ]
}

```
