# SDOHCC Observation Race OMB Practitioner Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Race OMB Practitioner Example

Language: en

Profile: [SDOHCC Observation Race OMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md)

**status**: Final

**category**: Personal Characteristic

**code**: Race OMB.1997

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**effective**: 2022-04-10 23:56:54+0000

**performer**: [Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)

**method**: Self Reported

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Race OMB.1997 | White |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationRaceOMBPractitionerExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "personal-characteristic"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72826-1"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "effectiveDateTime" : "2022-04-10T23:56:54.671Z",
  "performer" : [
    {
      "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample",
      "display" : "Dr Jan Water"
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "self-reported",
        "display" : "Self Reported"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "72826-1",
            "display" : "Race OMB.1997"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2106-3",
            "display" : "White"
          }
        ]
      }
    }
  ]
}

```
