# SDOHCC Observation Gender Identity Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Gender Identity Example

Language: en

Profile: [SDOHCC Observation Gender Identity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md)

**status**: Final

**category**: Personal Characteristic

**code**: Gender identity

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**effective**: 2022-04-10 23:56:54+0000

**performer**: [COLIN ABBAS](Patient-pat-53234.md)

**value**: Identifies as male gender

**method**: Self Reported



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationGenderIdentityExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationGenderIdentity"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "personal-characteristic"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "76691-5"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "effectiveDateTime" : "2022-04-10T23:56:54.671Z",
  "performer" : [
    {
      "reference" : "Patient/pat-53234",
      "display" : "COLIN ABBAS"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "446151000124109",
        "display" : "Identifies as male gender"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "self-reported",
        "display" : "Self Reported"
      }
    ]
  }
}

```
