# SDOHCC Observation Enrollment Status Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Enrollment Status Example

Language: en

Profile: [SDOHCC Observation Program Enrollment Status](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md)

**status**: Final

**category**: SDOH, Program Enrollment Status

**code**: Adult protective service (qualifier value)

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**focus**: [HealthcareService HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md)

**effective**: 2025-05-21 21:56:54+0000

**performer**: [Pat Williams](Practitioner-SDOHCC-PractitionerPatWilliamsMSWExample.md)

**value**: Enrolled



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationEnrollmentStatusExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "program-enrollment",
          "display" : "Program Enrollment Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "481021000124104",
        "display" : "Adult protective service (qualifier value)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "focus" : [
    {
      "reference" : "HealthcareService/SDOHCC-HealthcareServiceSocialCareProgram"
    }
  ],
  "effectiveDateTime" : "2025-05-21T21:56:54.671Z",
  "performer" : [
    {
      "reference" : "Practitioner/SDOHCC-PractitionerPatWilliamsMSWExample",
      "display" : "Pat Williams"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "enrolled",
        "display" : "Enrolled"
      }
    ]
  }
}

```
