# SDOHCC Lab Observation Lead Level Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Lab Observation Lead Level Example

Language: en

Profile: [US Core Laboratory Result Observation Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-lab.html)

**status**: Final

**category**: Laboratory

**code**: Lead [Mass/volume] in Blood

**subject**: [BABY ABBAS Male, DoB: 2023-06-15 ( Medical Record Number: 65313516351 (use: usual, ))](Patient-SDOHCC-PatientBabyAbbas.md)

**effective**: 2025-05-21 21:56:54+0000

**performer**: [Organization Special Supplemental Nutrition Program for Women, Infants and Children (WIC) Office](Organization-SDOHCC-OrganizationWICCommunityOrganizationExample.md)

**value**: 0.5 µg/dL

**interpretation**: Normal



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-LabObservationLeadLevelExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|7.0.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "5671-3",
        "display" : "Lead [Mass/volume] in Blood"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas"
  },
  "effectiveDateTime" : "2025-05-21T21:56:54.671Z",
  "performer" : [
    {
      "reference" : "Organization/SDOHCC-OrganizationWICCommunityOrganizationExample"
    }
  ],
  "valueQuantity" : {
    "value" : 0.5,
    "unit" : "µg/dL",
    "system" : "http://unitsofmeasure.org"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ]
}

```
