# SDOHCC Immunization Childhood Immunizations Example - SDOH Clinical Care v3.0.0-ballot

## Example Immunization: SDOHCC Immunization Childhood Immunizations Example

Language: en

Profile: [US Core Immunization Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-immunization.html)

**status**: Completed

**vaccineCode**: diphtheria, tetanus toxoids and acellular pertussis vaccine

**patient**: [BABY ABBAS Male, DoB: 2023-06-15 ( Medical Record Number: 65313516351 (use: usual, ))](Patient-SDOHCC-PatientBabyAbbas.md)

**occurrence**: 2024-06-15

**lotNumber**: DTAP12345

**site**: Left upper arm structure

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md) |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "SDOHCC-ImmunizationChildhoodImmunizationsExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|7.0.0"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/cvx",
        "code" : "20",
        "display" : "diphtheria, tetanus toxoids and acellular pertussis vaccine"
      },
      {
        "system" : "http://hl7.org/fhir/sid/ndc",
        "code" : "58160081011",
        "display" : "INFANRIX, 10 VIAL in 1 CARTON (58160-810-11) > .5 mL in 1 VIAL (58160-810-01) (package)"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas"
  },
  "occurrenceDateTime" : "2024-06-15",
  "lotNumber" : "DTAP12345",
  "site" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "368208006",
        "display" : "Left upper arm structure"
      }
    ]
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample",
        "display" : "Dr Jan Water"
      }
    }
  ]
}

```
