# SDOHCC HealthcareService Telecom Appointment Example - SDOH Clinical Care v3.0.0-ballot

## Example HealthcareService: SDOHCC HealthcareService Telecom Appointment Example

Language: en

Profile: [SDOHCC Healthcare Service](StructureDefinition-SDOHCC-HealthcareService.md)

**active**: true

**location**: [Location Family Counseling Services Deerland Clinic](Location-SDOHCC-LocationExample.md)

**name**: Family Counseling Services

**telecom**: ph: (555) appoint(Work), [familyCounseling@example.com](mailto:familyCounseling@example.com), ph: (555) office(Work), ph: (555) nursepr(Work)



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "SDOHCC-HealthcareServiceTelecomAppointmentExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService"
    ]
  },
  "language" : "en",
  "active" : true,
  "location" : [
    {
      "reference" : "Location/SDOHCC-LocationExample"
    }
  ],
  "name" : "Family Counseling Services",
  "telecom" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment",
          "valueBoolean" : true
        }
      ],
      "system" : "phone",
      "value" : "(555) appoint",
      "use" : "work"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment",
          "valueBoolean" : true
        }
      ],
      "system" : "email",
      "value" : "familyCounseling@example.com",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(555) office",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(555) nursepr",
      "use" : "work"
    }
  ]
}

```
