# SDOHCC Condition Protective Factor Example - SDOH Clinical Care v3.0.0-ballot

## Example Condition: SDOHCC Condition Protective Factor Example

Language: en

Profile: [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md)

**clinicalStatus**: Active

**verificationStatus**: Unconfirmed

**category**: Health Concern, SDOH, Protective Factor

**code**: Has access to transportation (finding)

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**onset**: 2021-04-26 13:56:33+0000 --> (ongoing)

**asserter**: [COLIN ABBAS](Patient-pat-53234.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "SDOHCC-ConditionProtectiveFactor",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
    ]
  },
  "language" : "en",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "unconfirmed",
        "display" : "Unconfirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category",
          "code" : "health-concern",
          "display" : "Health Concern"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "version" : "7.0.0",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "protective-factor",
          "display" : "Protective Factor"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1137434003",
        "display" : "Has access to transportation (finding)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "onsetPeriod" : {
    "start" : "2021-04-26T13:56:33.747Z"
  },
  "asserter" : {
    "reference" : "Patient/pat-53234",
    "display" : "COLIN ABBAS"
  }
}

```
