# Industry Initiatives - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* **Industry Initiatives**

## Industry Initiatives

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This section is an ongoing compilation of industry-wide, including international, digital identity and patient matching projects, with input from [Digital Identity](digital-identity.md) & [Patient Matching](patient-matching.md) on cross-cutting capabilities and how various efforts may be leveraged in the healthcare setting. These initiatives are about solving identity and matching. The current NIST 800-63 standard, a measure for evaluating identity verification and authentication assurance, is not listed on this page.

### Digital Identity and Patient Matching Projects

[AHIMA Naming Policy Recommendations white paper](https://ahima.org/media/blfdriqj/326_21_namingpolicywhitepaper_final.pdf?oid=302787)

[Canadian Digital Identity Ecosystem](https://diacc.ca/trust-framework/)'s Digital Trust And Identity and National Technical Specification for digital credentials and digital trust services

[CARIN Digital Identity](https://www.carinalliance.com/our-work/digitalidentity/)

[DirectTrust Guidance for Authentication of Individual Identity](https://directtrust.app.box.com/s/wr4qa2pqbetxyp78sbtfci5jlzofis67/file/1025491591524)

[ECRI Health IT Safe Practices: Toolkit for the Safe Use of Health IT for Patient Identification](https://www.ecri.org/Resources/HIT/Patient%20ID/Patient_Identification_Toolkit_final.pdf)

[Finland](https://oikeusministerio.fi/en/-/10623/finland-and-germany-intensify-cooperation-to-promote-digital-identification) and Germany Self-sovereign Identity-based Collaboration in the EU

[Global Assured Identity Network (GAIN)](https://gainforum.org/)

[OpenID for Identity Assurance](https://openid.net/wg/ekyc-ida/)

[Patient ID Now Coalition Framework for a National Strategy on Patient Identity](https://patientidnow.org/) (The Framework identified nine areas for definition of a national patient identity strategy)

-------

### IHE Profiles & other standards for Patient Identity Management

[CARIN digital insurance card for member IDs](https://confluence.hl7.org/display/CAR/CARIN+IG+for+Digital+Insurance+Card)

[Direct Standard - Implementation Guide for Expressing Context in Direct Messaging](https://wiki.directproject.org/wiki/File:Implementation_Guide_for_Expressing_Context_in_Direct_Messaging_v1.1.pdf)

[Overview: IHE whitepaper on Document Sharing Health Information Exchanges](https://profiles.ihe.net/ITI/HIE-Whitepaper/index.html#5-patient-identity-management)

IHE Trial Implmentation Resources

    [IHE - Patient Demographics Query for Mobile (PDQm)](https://profiles.ihe.net/ITI/PDQm/index.html)

    [IHE - Patient Identifier Cross-reference for Mobile (PIXm)](https://profiles.ihe.net/ITI/PIXm/index.html)

    [IHE - Patient Master Identity Registry (PMIR)](https://profiles.ihe.net/ITI/PMIR/index.html)

IHE Final Text Profiles (normative)

    [IHE - Cross-Community Patient Discovery (XCPD)](https://profiles.ihe.net/ITI/TF/Volume1/ch-27.html)

    [IHE - Patient Administration Management (PAM)](https://profiles.ihe.net/ITI/TF/Volume1/ch-14.html)

    [IHE - Patient Demographics Query (PDQ)](https://profiles.ihe.net/ITI/TF/Volume1/ch-8.html)

    [IHE - Patient Identifier Cross-Referencing (PIX)](https://profiles.ihe.net/ITI/TF/Volume1/ch-5.html)

