# Change Log - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* **Change Log**

## Change Log

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Changes from the previous version are summarized below with links to the corresponding HL7 ticket. The summaries below are non-normative. No change log was created for STU1 due to it being the first published version of this IG.

### Version 2.0.0 - STU2 (Change log is new to this version)

| | |
| :--- | :--- |
| [FHIR-51538](https://jira.hl7.org/browse/FHIR-51538) | Update $IDI-match operation to include $match requirements |
| [FHIR-51409](https://jira.hl7.org/browse/FHIR-51409) | Update L0 and L1 invariants to fix identifier bugs |
| [FHIR-49853](https://jira.hl7.org/browse/FHIR-49853) | No changelog page for Digital Identity and Patient Matching IG |
| [FHIR-39349](https://jira.hl7.org/browse/FHIR-39349) | We omit a method for verifying mobile number |
| [FHIR-40548](https://jira.hl7.org/browse/FHIR-40548) | Update to OpenID section to include responses |
| [FHIR-47699](https://jira.hl7.org/browse/FHIR-47699) | Update "Notice" to "Notification" in IG |
| [FHIR-47698](https://jira.hl7.org/browse/FHIR-47698) | Additional strong/fair evidence format updates |
| [FHIR-47554](https://jira.hl7.org/browse/FHIR-47554) | Update credits list |
| [FHIR-47036](https://jira.hl7.org/browse/FHIR-47036) | Clarify only URLs in fulLURL |
| [FHIR-47546](https://jira.hl7.org/browse/FHIR-47546) | MUST to SHALL |
| [FHIR-47548](https://jira.hl7.org/browse/FHIR-47548) | Changing SHALL to non-conformance language |
| [FHIR-47549](https://jira.hl7.org/browse/FHIR-47549) | Separate run-on sentence re: Trusted Referee |
| [FHIR-47550](https://jira.hl7.org/browse/FHIR-47550) | Improve readability of individual identity verification levels |
| [FHIR-47551](https://jira.hl7.org/browse/FHIR-47551) | Clarify conditions when SSN can be used |
| [FHIR-48027](https://jira.hl7.org/browse/FHIR-48027) | Clarify levels lacking explicit photo ID comparison requirement |
| [FHIR-48287](https://jira.hl7.org/browse/FHIR-48287) | Reorder language around note in 2.2 and clarify separate IdP systems |
| [FHIR-48033](https://jira.hl7.org/browse/FHIR-48033) | Improve precision of wording in 5.1.1 Identity Proofing Workflow |
| [FHIR-47663](https://jira.hl7.org/browse/FHIR-47663) | Create additional example demonstrating incomplete information and weighted match input score too low |
| [FHIR-48045](https://jira.hl7.org/browse/FHIR-48045) | Add link to verified attributes in glossary, correction to clarify IAL1.8 for internal consistency with Consumer Match section |
| [FHIR-48049](https://jira.hl7.org/browse/FHIR-48049) | Clarify rationale for avoiding I and O in enterprise identifiers |
| [FHIR-48034](https://jira.hl7.org/browse/FHIR-48034) | Clarify match workflow pre-conditions 5.1.2 |
| [FHIR-48035](https://jira.hl7.org/browse/FHIR-48035) | Clarify natch workflow outcome in 5.1.2 |
| [FHIR-48050](https://jira.hl7.org/browse/FHIR-48050) | Added links to supporting guidance in 5.1.1, paragraph 4 |
| [FHIR-48051](https://jira.hl7.org/browse/FHIR-48051) | Added verified attribute details to Glossary |
| [FHIR-47044](https://jira.hl7.org/browse/FHIR-47044) | Clafiry mDL guidance in Identity Assurance page |
| [FHIR-48026](https://jira.hl7.org/browse/FHIR-48026) | Use terms defined in cited NIST publications for added precision |
| [FHIR-48030](https://jira.hl7.org/browse/FHIR-48030) | Clarify requirements for section 2.2 for IAL1.5 |
| [FHIR-45206](https://jira.hl7.org/browse/FHIR-45206) | Add attribute applicability section 3.8 with criteria for field matches based on codes |
| [FHIR-47700](https://jira.hl7.org/browse/FHIR-47700) | Add Public Health as Entity Type in section 2.7 |
| [FHIR-48031](https://jira.hl7.org/browse/FHIR-48031) | Clarify evidentiary mitigation claim in IAL1.6 |
| [FHIR-48053](https://jira.hl7.org/browse/FHIR-48053) | Clarify verification terminology used in section 4.2 |
| [FHIR-48052](https://jira.hl7.org/browse/FHIR-48052) | Clarifications to Use Cases to make it clearer how entities come to shared consensus about identity of user |
| [FHIR-45199](https://jira.hl7.org/browse/FHIR-45199) | Requirements to clarify when an individual has been authenticated or when sufficient demographics plus sufficiently high authentication by a trusted IdP are equivalent to local authentication |
| [FHIR-45312](https://jira.hl7.org/browse/FHIR-45312) | Include minimum identity verification levels in invariant definitions |
| [FHIR-45449](https://jira.hl7.org/browse/FHIR-45449) | Include Level 2 invariant at IAL2/IDIAL2 |
| [FHIR-50257](https://jira.hl7.org/browse/FHIR-50257) | Clarifying minimum level of identity assurance for responder records management (B2B matches) |
| [FHIR-48041](https://jira.hl7.org/browse/FHIR-48041) | Adding ID before our IAL levels where they differ from NIST |
| [FHIR-48298](https://jira.hl7.org/browse/FHIR-48298) | Rules for comparing SSN (last 4) to SSN |
| [FHIR-48677](https://jira.hl7.org/browse/FHIR-48677) | Adding push and other patient-facing workflows to examples |
| [FHIR-49054](https://jira.hl7.org/browse/FHIR-49054) | Clarified that IDIAL1.5 is not the minimum bar for Digital Identifier; rather, it is IDIAL1.8; additional technical corrections related to FHIR-48032 |
| [FHIR-48282](https://jira.hl7.org/browse/FHIR-48282) | Clarify requirements for how IAL intersects with workflows |
| [FHIR-50930](https://jira.hl7.org/browse/FHIR-50930) | Clarify that alternative numbers are verified as with mobile numbers |
| [FHIR-49647](https://jira.hl7.org/browse/FHIR-49647) | Identifier must have been issued by IdP to be shared (technical correction portion of ticket) |
| [FHIR-51016](https://jira.hl7.org/browse/FHIR-51016) | Digital Identifier section erroneously states IDIAL1.5 can be used |
| [FHIR-46410](https://jira.hl7.org/browse/FHIR-46410) | Guidance on including explicit authorization and token expiration time frame |
| [FHIR-47661](https://jira.hl7.org/browse/FHIR-47661) | n-tuple or n-combination of PII attributes |
| [FHIR-46755](https://jira.hl7.org/browse/FHIR-46755) | Need normative requirements linking (or not linking) this IG to Patient $match |
| [FHIR-48294](https://jira.hl7.org/browse/FHIR-48294) | Clarify how HL7 Identifier works |
| [FHIR-50088](https://jira.hl7.org/browse/FHIR-50088) | Clarify requirements for IAL2 |
| [FHIR-50086](https://jira.hl7.org/browse/FHIR-50086) | Clarify how Trusted Referees or Trusted Agents can vouch for individuals |
| [FHIR-45307](https://jira.hl7.org/browse/FHIR-45307) | Include mDL as a Valid Identification Source |
| [FHIR-48047](https://jira.hl7.org/browse/FHIR-48047) | Hashing is not effective for preserving privacy or facilitating matches for many UTF-8 characters. |
| [FHIR-50085](https://jira.hl7.org/browse/FHIR-50085) | Add "Trusted Referee" to glossary |
| [FHIR-47555](https://jira.hl7.org/browse/FHIR-47555) | Plain Language Summary about HL7 and this Guide to the home page |
| [FHIR-48042](https://jira.hl7.org/browse/FHIR-48042) | NIST 800-63-3 guidelines for address confirmation has additional requirements not explicitly mentioned |
| [FHIR-51424](https://jira.hl7.org/browse/FHIR-51424) | State IG Status Explicitly |
| [FHIR-43188](https://jira.hl7.org/browse/FHIR-43188) | Clarify "such queries" in Patient Match 4.2 |
| [FHIR-40616](https://jira.hl7.org/browse/FHIR-40616) | Clarification that identifier details are subject to change pending official registration |
| [FHIR-44920](https://jira.hl7.org/browse/FHIR-44920) | Reporting Issues in Matching |
| [FHIR-44797](https://jira.hl7.org/browse/FHIR-44797) | Create Examples Demonstrating Digital Identifiers in Patient Resources |
| [FHIR-51517](https://jira.hl7.org/browse/FHIR-51517) | Update $match to $idi-match in 10.0.2, 10.0.3, 10.0.4 |

