# IDI Patient L1 - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDI Patient L1**

## Resource Profile: IDI Patient L1 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1 | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IDIPatientL1 |

 
(Level 1 weighting) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements which, when consistent with an identity verification event performed at IDIAL1.8 or higher, meet a combined 'weighted level' of at least 10 

**Usages:**

* Use this Profile: [IDI Match Input Parameters](StructureDefinition-idi-match-input-parameters.md)
* Examples for this Profile: [Patient/ExamplePatientINCOMPLETE](Patient-ExamplePatientINCOMPLETE.md) and [Patient/ExamplePatientL1](Patient-ExamplePatientL1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.identity-matching|current/StructureDefinition/IDI-Patient-L1)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IDI-Patient-L1.csv), [Excel](StructureDefinition-IDI-Patient-L1.xlsx), [Schematron](StructureDefinition-IDI-Patient-L1.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IDI-Patient-L1",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1",
  "version" : "2.0.0",
  "name" : "IDIPatientL1",
  "title" : "IDI Patient L1",
  "status" : "active",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "(Level 1 weighting) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements which, when consistent with an identity verification event performed at IDIAL1.8 or higher, meet a combined 'weighted level' of at least 10",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Patient information to be supplied to $match operation conforming to Level 1 weighting of information",
        "definition" : "Demographics and other administrative information about an individual which can be utilized within the $match operation meeting a minimum combined weighting higher than previous levels. The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements, when consistent with identity verification performed at IDIAL1.8 or greater, which meet a combined ‘weighted level’ of at least 10",
        "constraint" : [
          {
            "key" : "idi-L1",
            "severity" : "error",
            "human" : "Requestors asserting compliance with this Invariant level are also thereby indicating that all included demographics are consistent with an identity verification event performed as part of a documented process that is compliant with this IG. Combined weighted values of included elements must have a minimum value of 10 (see Patient Weighted Elements table). Note that the logic for computing weights is somewhat imperfect, particularly considering that it does not confirm that exactly the expected coded type is the one that exists in a match request; this is acceptable because it will not in itself lead to mismatches, though it may give requestors an overly-optimistic sense of their input quality.",
            "expression" : "iif(identifier.where(value.exists() and(type.coding.where(code = 'PPN'\r\n    or code = 'DL'\r\n    or code = 'STID'))).count() * 5 > 10, 10, identifier.where(value.exists() and(type.coding.where(code = 'PPN'\r\n    or code = 'DL'\r\n    or code = 'STID'))).count() * 5) + iif(((address.exists(use = 'home') and address.line.exists() and(address.postalCode.exists() or(address.state.exists() and address.city.exists()))).toInteger() + (identifier.type.coding.exists(code != 'PPN'\r\n    and code != 'DL'\r\n    and code != 'STID') and identifier.value.exists()).toInteger() + (telecom.exists(system = 'email') and telecom.value.exists()).toInteger() + (telecom.exists(system = 'phone') and telecom.value.exists()).toInteger() + (photo.exists()).toInteger()) = 1, 4, iif(((address.exists(use = 'home') and address.line.exists() and(address.postalCode.exists() or(address.state.exists() and address.city.exists()))).toInteger() + (identifier.type.coding.exists(code != 'PPN'\r\n    and code != 'DL'\r\n    and code != 'STID') and identifier.value.exists()).toInteger() + (telecom.exists(system = 'email') and telecom.value.exists()).toInteger() + (telecom.exists(system = 'phone') and telecom.value.exists()).toInteger() + (photo.exists()).toInteger()) > 1, 5, 0)) + (name.family.exists() and name.given.exists()).toInteger() * 3 + (birthDate.exists().toInteger() * 2)\r\n    >= 10",
            "source" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1"
          }
        ]
      },
      {
        "id" : "Patient.meta.profile",
        "path" : "Patient.meta.profile",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on pattern",
          "ordered" : false,
          "rules" : "open"
        },
        "comment" : "meta.profile is required as a matter of convenience of receiving systems. The meta.profile SHALL be used by the Server to hint/assert/declare that this instance conforms to the stated profiles (with business versions). meta.profile does not capture any business logic, processing directives, or semantics (for example, inpatient or outpatient). "
      },
      {
        "id" : "Patient.meta.profile:assertedProfile",
        "path" : "Patient.meta.profile",
        "sliceName" : "assertedProfile",
        "min" : 0,
        "max" : "1",
        "patternCanonical" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1"
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/identity-matching/ValueSet/Identity-Identifier-vs"
        }
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "constraint" : [
          {
            "key" : "idi-2",
            "severity" : "error",
            "human" : "Either the given or family name SHALL be present",
            "expression" : "given.exists() or family.exists()",
            "source" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1"
          }
        ]
      }
    ]
  }
}

```
