# Patient-L1 - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient-L1**

## Example Patient: Patient-L1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Language: en-US

Profile: [IDI Patient L1](StructureDefinition-IDI-Patient-L1.md)

Justin Case Female, DoB: 1992-05-17 ( Driver's license number)

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Marital Status: | unknown |
| Contact Detail | * ph: 726-555-2900(Mobile)
* 418 Teapot Lane Raleigh NC 27513 
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ExamplePatientL1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1"
    ]
  },
  "language" : "en-US",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "DL"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/NamingSystem/NorthCarolinaDLN",
      "value" : "3902-16532901",
      "assigner" : {
        "display" : "North Carolina"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Case",
      "given" : ["Justin"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "726-555-2900",
      "use" : "mobile"
    }
  ],
  "gender" : "female",
  "birthDate" : "1992-05-17",
  "address" : [
    {
      "type" : "physical",
      "line" : ["418 Teapot Lane"],
      "city" : "Raleigh",
      "state" : "NC",
      "postalCode" : "27513"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "UNK"
      }
    ]
  }
}

```
