# Patient-L0 - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient-L0**

## Example Patient: Patient-L0

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Language: en-US

Profile: [IDI Patient L0](StructureDefinition-IDI-Patient-L0.md)

Nancy Paeshent Female, DoB: 1988-02-11 ( Person number)

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Marital Status: | unknown |
| Contact Detail | 321 South Maple Street Scranton PA 18503 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ExamplePatientL0",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L0"
    ]
  },
  "language" : "en-US",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "4004-202-9999-12345678901"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Paeshent",
      "given" : ["Nancy"]
    }
  ],
  "gender" : "female",
  "birthDate" : "1988-02-11",
  "address" : [
    {
      "type" : "physical",
      "line" : ["321 South Maple Street"],
      "city" : "Scranton",
      "state" : "PA",
      "postalCode" : "18503"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "UNK"
      }
    ]
  }
}

```
