# Patient1 - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient1**

## Example Patient: Patient1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Language: en-US

Profile: [IDI Patient](StructureDefinition-IDI-Patient.md)

Johnny Beegood Male, DoB: 1986-05-01 ( Member Number)

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Marital Status: | unknown |
| Contact Detail | * ph: 301-555-2112(Mobile)
* 123 Main Street Pittsburgh PA 12519 
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ExamplePatient",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient"
    ]
  },
  "language" : "en-US",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MB"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "1234-234-1243-12345678901"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Beegood",
      "given" : ["Johnny"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "301-555-2112",
      "use" : "mobile"
    }
  ],
  "gender" : "male",
  "birthDate" : "1986-05-01",
  "address" : [
    {
      "type" : "physical",
      "line" : ["123 Main Street"],
      "city" : "Pittsburgh",
      "state" : "PA",
      "postalCode" : "12519"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "UNK"
      }
    ]
  }
}

```
