# Identity-HL7-Person-Identifier - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identity-HL7-Person-Identifier**

## NamingSystem: Identity-HL7-Person-Identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/NamingSystem/Identity-HL7-Person-Identifier | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:HL7PersonIdentifier |

 
Digital Identifier to assist in patient matching. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "Identity-HL7-Person-Identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://hl7.org/fhir/us/identity-matching/NamingSystem/Identity-HL7-Person-Identifier"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "2.0.0"
    }
  ],
  "name" : "HL7PersonIdentifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2023-02-20",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "Digital Identifier to assist in patient matching.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier"
    }
  ]
}

```
