# MATCHOperationResponse - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MATCHOperationResponse**

## Example Bundle: MATCHOperationResponse



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "MATCHOperationResponse",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-bundle"
    ]
  },
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:c3c6f1c5-3072-439e-a8ef-ba6a57ae3aa5",
    "assigner" : {
      "reference" : "http://example.org/Organization/OrgExample"
    }
  },
  "type" : "searchset",
  "link" : [
    {
      "relation" : "self",
      "url" : "http://example.org/Bundle/MATCHOperationResponse"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/Organization/OrgExample",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "OrgExample",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_OrgExample\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization Insurance Company</b></p><a name=\"OrgExample\"/><p><b>name</b>: Insurance Company</p><p><b>address</b>: 688 Asylum Street Hartford CT 06155</p></div>"
        },
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "pay",
                "display" : "Payer"
              }
            ]
          }
        ],
        "name" : "Insurance Company",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "860-547-5001",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["688 Asylum Street"],
            "city" : "Hartford",
            "state" : "CT",
            "postalCode" : "06155",
            "country" : "US"
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Patient/PatExample",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "PatExample",
        "meta" : {
          "lastUpdated" : "2020-07-07T13:26:22.0314215+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_PatExample\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Person PatExample</b></p><a name=\"PatExample\"/><p><b>name</b>: Johnny Beegood (Official)</p><p><b>birthDate</b>: 1986-05-01</p><p><b>address</b>: 123 Main Street Pittsburgh PA 12519 (physical)</p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MB"
                }
              ]
            },
            "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
            "value" : "1234-234-1243-12345678901"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Beegood",
            "given" : ["Johnny"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-05-01",
        "address" : [
          {
            "type" : "physical",
            "line" : ["123 Main Street"],
            "city" : "Pittsburgh",
            "state" : "PA",
            "postalCode" : "12519"
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
