# hl7.fhir.us.identity-matching#2.0.0: Interoperable Digital Identity and Patient Matching

## Pages

* [Home](index.md)
* [Artifacts Summary](artifacts.md)
* [Change Log](changelog.md)
* [Digital Identity](digital-identity.md)
* [Downloads](downloads.md)
* [Glossary](glossary.md)
* [Guidance on Identity Assurance](guidance-on-identity-assurance.md)
* [Industry Initiatives](industry-initiatives.md)
* [Patient Matching](patient-matching.md)
* [Use Cases](use-cases.md)

## Resources

### CodeSystems

* [Identity Identifier Code System](CodeSystem-Identity-Identifier-cs.md)

### ValueSets

* [Identity Identifier Value Set](ValueSet-Identity-Identifier-vs.md)

### Resource Profiles

* [FAST Identity UDAP Person](StructureDefinition-FASTIDUDAPPerson.md)
* [IDI Patient L0](StructureDefinition-IDI-Patient-L0.md)
* [IDI Patient L1](StructureDefinition-IDI-Patient-L1.md)
* [IDI Patient L2](StructureDefinition-IDI-Patient-L2.md)
* [IDI Patient](StructureDefinition-IDI-Patient.md)
* [IDI Match Bundle](StructureDefinition-idi-match-bundle.md)
* [IDI Match Input Parameters](StructureDefinition-idi-match-input-parameters.md)
* [IDI Match Output Parameters](StructureDefinition-idi-match-output-parameters.md)

### ImplementationGuides

* [Interoperable Digital Identity and Patient Matching](index.md)

### NamingSystems

* [HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md)

### OperationDefinitions

* [IDI Match Operation](OperationDefinition-IDI-match.md)

### Examples

* [MATCHOperationResponse (Bundle)](Bundle-MATCHOperationResponse.md)
* [Burgers University Medical Center (Organization)](Organization-abc-hospital.md)
* [Secure Idp (Organization)](Organization-def-idp.md)
* [XYZ Insurance (Organization)](Organization-xyz-payer.md)
* [IDIMatchInputParameters-Example (Parameters)](Parameters-IDIMatchInputParameters-Example.md)
* [IDIMatchOutputParameters-Example (Parameters)](Parameters-IDIMatchOutputParameters-Example.md)
* [ExamplePatient (Patient)](Patient-ExamplePatient.md)
* [ExamplePatientINCOMPLETE (Patient)](Patient-ExamplePatientINCOMPLETE.md)
* [ExamplePatientL0 (Patient)](Patient-ExamplePatientL0.md)
* [ExamplePatientL1 (Patient)](Patient-ExamplePatientL1.md)
* [ExamplePatientL2 (Patient)](Patient-ExamplePatientL2.md)
* [patient-multi-digital-identifier (Patient)](Patient-patient-multi-digital-identifier.md)
* [FASTIDUDAPPerson-Example (Person)](Person-FASTIDUDAPPerson-Example.md)
* [patient-authorized-representative (RelatedPerson)](RelatedPerson-patient-authorized-representative.md)
