# Home - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching | *Version*:2.0.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DigitalIdentity |

This Identity-focused FHIR implementation guide (IG) has been established upon the recommendations of ONC's FHIR at Scale Task Force (FAST) Identity Team and has been adapted from solution documents previously published by the team. The IG’s primary objective is to provide guidance on identity verification and patient matching as used in workflows pertinent to FHIR exchange and to facilitate cross-organizational and cross-network interoperability.

 

### About HL7

[HL7](http://hl7.org/), which stands for Health Level Seven, creates standards to help different healthcare computer systems talk to each other. These HL7 standards are a special language or set of rules that lets information be shared between hospitals, doctors’ offices (e.g. Electronic Health Record Systems), labs, patients (e.g. via patient portals), pharmacies, and insurers, among others.

One of the HL7 standards is HL7 FHIR (Fast Healthcare Interoperability Resources). It helps connect healthcare systems, making it easier for doctors, nurses, and other healthcare professionals to share important information about patients. For example, if you have a lab test at a hospital, HL7 FHIR helps send the results to your doctor’s office so they can provide the right care.

A goal of HL7 is to make sure everyone involved in your healthcare has the right information at the right time. Our standards help machines and people, including you, work together to make better decisions for your health. HL7 sets rules that computer systems follow, so they can understand and share information in a consistent and reliable way.

To learn more about HL7, you can visit the website [hl7.org](http://hl7.org/)

The people at HL7 make guides that explain how to use the rules (standards) for different things. These guides bring the rules together and show how to use them for specific purposes.

### About This Guide

This IG profiles the FHIR patient $match operation for use in cross-organizational workflows and serves as a set of best practices for person matching and identity management in similar FHIR transactions, as well as in other non-FHIR transaction types.

The requirements described in this guide are intended to align with the solutions originally proposed by the ONC FHIR at Scale Task Force’s Identity Tiger Team.

This Implementation Guide was designed with the goals of:

* Establishing a Digital Identifier standard that can be used along with limited demographics to deterministically match on an individual human or organizational identity including across different systems, and considering its relative accuracy matching with this identifier is the preferred matching method;
* Improving patient matching that continues to rely on demographics, so that matching is based on attributes verified at a high level of assurance along with rubrics determined through stakeholder consensus–giving implementers a framework that may be considered recognized security practices for patient matching and identity management;
* Establishing a well-defined 1) professional healthcare user and 2) consumer-facing identity management playbook that begins with the identity verification event and continues through a transaction with requirements of identity services, requesters, and responders, in order to provide measurable confidence in the identities of all parties to a healthcare transaction such that reliable health data results may be returned, results returned more often, with increased predictably, and at increasing scale;
* Although the IG is not limited to FHIR in its applicability to person matching and Digital Identity, its guidance prioritizes how to use identity concepts, match identities, and locate records with FHIR and complements [HL7 UDAP FAST Security for Scalable Registration, Authentication, and Authorization](https://hl7.org/fhir/us/udap-security), particularly through its [Consumer Match](patient-matching.md#consumer-match) requirements for determining whether a user who was authenticated by a third-party identity service matches an individual on the implementer's system and through automated federation of trusted OpenID Connect services using existing healthcare PKI and Tiered OAuth.

This guide is divided into several pages which are listed in the menu bar.

* [Home](index.md): The home page provides the introduction and background for this project and general requirements that apply to all workflows described in this guide.
* [Guidance on Identity Assurance](guidance-on-identity-assurance.md): This page describes best practices for individual and organizational identity verification in the most common workflows necessary to support healthcare-related transactions.
* [Patient Matching](patient-matching.md): This page describes the appropriate usage of person matching for cross-organizational exchange.
* [Digital Identity](digital-identity.md): This page provides best practices for individual and organizational identity management in the healthcare context.
* [Artifacts](artifacts.md): This page provides additional conformance artifacts for FHIR resources.
* [Use Cases](use-cases.md): This page provides workflows around core Identity concepts, as well as Use Case workflows that highlight different types of healthcare transactions.
* [Industry Initiatives](industry-initiatives.md): This page includes a compilation of industry-wide digital identity and patient matching projects.

 

### Executive Summary

This IG provides guidance to enhance current workflows that support person matching and digital identity, and envisions a path for both providing more specific guidance and incorporating emerging identity concepts over time. This specification contributes to a long-term goal of establishing Digital Identity that is suited for interoperable use by providing guidance on identity assurance so that these best practices for attribute and evidence verification can serve as a foundation for better person matching. The IG also profiles the patient $match operation for cross-organizational use and highlights best practices for using verified matching attributes (i.e., demographics and other personal information) when responding to a match request, managing and using Digital Identifiers, and interpreting match results.

This guide will address the two concepts of patient matching and Digital Identity with care to differentiate between the two distinct disciplines and the workflows usually unique to one concept or the other:

> **Identity.**Digital health identity refers to the technology and processes that support personal identity as it pertains to electronic health information. Digital health identity includes identifiers as well as components such as matching, identity verification (also referred to as proofing or vetting), identity authentication, authorization and access control, and other technologies and processes.

> **Patient Matching.**Patient Matching and record linkage help address interoperability by determining whether records—both those held within a single facility and those in different healthcare organizations—correctly refer to a specific individual. Matching methods generally rely on demographic information, such as name and date of birth.

Research has shown that matching is improved when higher-quality demographics are provided in the match request; verifying the identity of an individual at a specific identity assurance level (IAL1, IAL2, etc.), and that any match input data is consistent with the identity verification event, is a method that improves this quality so that we can measure in a standard way the data included in a match request. For this reason, this IG will provide both guidance on how to implement and improve identity assurance and how to leverage identity assurance in matching.

When the identity of the person who is authenticated in a transaction is known with high confidence, this information can be used in an access decision, e.g., Patient-Directed Exchange. This allows implementers to rely on user authentication in this workflow instead of probabilistic matching, which becomes increasingly convenient as federated identity services proliferate. This also reduces the number of credentials an individual needs to maintain.

As a secondary effect, digital credentials with high-confidence identity and authentication assurance and a globally unique identifier associated with the individual, even in Business-to-Business matching (where the patient is not authenticated as being present in the transaction), emulate the perfect matching described in the paragraph above. Attempting to match on such a unique identifier is a preferred best practice over matching with demographics alone.

When identity verification has been completed for an individual, the process of verifying that demographic attributes are consistent with a unique individual in the real world makes the attributes more meaningful in match requests and improves match quality when probabilistic matching must be used.

 

### Testing

For readers that are looking to test an implementation of this guide, additional testing resources can be found on the [Implementer Support page](https://confluence.hl7.org/display/FAST/FAST+Implementer+Support) of the HL7 FAST Confluence site.

 

### Credits

* _**Contributors:**_:  
  * Paul Vaughan:  
  * Optum:  
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Carmen Smiley
  * Optum: HRSA
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Ari Kermaier
  * Optum: Oracle
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Aaron Nusstein
  * Optum: Lantana Consulting Group
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Jeff Brown
  * Optum: Lantana Consulting Group
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan:  
  * Optum:  
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Vijey Kris Sridharan
  * Optum: United Healthcare
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Jim St. Clair
  * Optum: MyLigo
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Catherine Schulten
  * Optum: Walmart
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Ryan Howells
  * Optum: Leavitt Partners
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Rita Torkzadeh
  * Optum: Independent Consultant
  *  :  
* _**Contributors:**_:  
  * Paul Vaughan: Humberto Lee
  * Optum: Lantana Consulting Group
  *  :  

 
 This IG was made possible by the thoughtful contributions and feedback of the following additional people and organizations:

The members of the ONC FHIR at Scale Taskforce (FAST) Identity Team

The members of the HL7 Patient Administration Work Group

 

(1) [Patient Identity Integrity White Paper](https://www.justassociates.com/application/files/1414/9134/1517/PIIWhitePaper.pdf) HIMSS, December 2009 
 (2) [Approaches and Challenges to Electronically Matching Patients’ Records across Providers](https://www.gao.gov/assets/gao-19-197.pdf) GAO, January 2019 
 (3) [The Sequoia Project](https://sequoiaproject.org/resources/patient-matching/) 
 (4) [Defining and Evaluating Patient-Empowered Approaches to Improving Record Matching](https://www.rand.org/content/dam/rand/pubs/research_reports/RR2200/RR2275/RAND_RR2275.pdf) RAND, 2018

