# Downloads - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Package File

The following package file includes an NPM package file used by many FHIR tools. It includes all the value sets, profiles, extensions, list of pages and URLs in the implementation guide (IG), etc. for this version of the IG. This file contains all of the rules about what makes the profiles valid and should be the first choice when generating any implementation artifacts. Implementers will still need to be familiar with the contents of this specification and the applicable profiles to make a conformant implementation. See the overview on validating [FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html):

[Package](package.tgz)

 
 

### Downloadable Copy of Entire Specification

The following zip file contains a downloadable version of this IG that can be hosted locally:

[Downloadable Copy](full-ig.zip)

 
 

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.identity-matching.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.identity-matching.r4b)](package.r4b.tgz) are available.

#### Dependency Table

#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.0.0/CodeSystem-ISO3166Part1.html): [DigitalIdentity](index.md), [FASTIDUDAPPerson](StructureDefinition-FASTIDUDAPPerson.md)...Show 11 more,[HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md),[IDIMatch](OperationDefinition-IDI-match.md),[IDIMatchBundle](StructureDefinition-idi-match-bundle.md),[IDIMatchInputParameters](StructureDefinition-idi-match-input-parameters.md),[IDIMatchOutputParameters](StructureDefinition-idi-match-output-parameters.md),[IDIPatient](StructureDefinition-IDI-Patient.md),[IDIPatientL0](StructureDefinition-IDI-Patient-L0.md),[IDIPatientL1](StructureDefinition-IDI-Patient-L1.md),[IDIPatientL2](StructureDefinition-IDI-Patient-L2.md),[IdentityIdentifierCodeSystem](CodeSystem-Identity-Identifier-cs.md)and[IdentityIdentifierValueSet](ValueSet-Identity-Identifier-vs.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [Bundle/MATCHOperationResponse](Bundle-MATCHOperationResponse.md) and [Parameters/IDIMatchOutputParameters-Example](Parameters-IDIMatchOutputParameters-Example.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Bundle/MATCHOperationResponse](Bundle-MATCHOperationResponse.md), [Parameters/IDIMatchInputParameters-Example](Parameters-IDIMatchInputParameters-Example.md)...Show 6 more,[Parameters/IDIMatchOutputParameters-Example](Parameters-IDIMatchOutputParameters-Example.md),[Patient/ExamplePatient](Patient-ExamplePatient.md),[Patient/ExamplePatientINCOMPLETE](Patient-ExamplePatientINCOMPLETE.md),[Patient/ExamplePatientL0](Patient-ExamplePatientL0.md),[Patient/ExamplePatientL1](Patient-ExamplePatientL1.md)and[Patient/ExamplePatientL2](Patient-ExamplePatientL2.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [Parameters/IDIMatchInputParameters-Example](Parameters-IDIMatchInputParameters-Example.md), [Patient/ExamplePatient](Patient-ExamplePatient.md)...Show 4 more,[Patient/ExamplePatientINCOMPLETE](Patient-ExamplePatientINCOMPLETE.md),[Patient/ExamplePatientL0](Patient-ExamplePatientL0.md),[Patient/ExamplePatientL1](Patient-ExamplePatientL1.md)and[Patient/ExamplePatientL2](Patient-ExamplePatientL2.md)
* [ParticipationFunction](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationFunction.html): [RelatedPerson/patient-authorized-representative](RelatedPerson-patient-authorized-representative.md)


