# Artifacts Summary - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [IDI Match Operation](OperationDefinition-IDI-match.md) | §1:This operation is an alternative of the $match operation, constrained to meet the additional requirements found in this IG. One of the IDI Patient profiles outline in this guide (IDI-Patient, IDI-Patient-L0, IDI-Patient-L1, IDI-Patient-L2) SHALL be used as the input for the match request. An IDI-Match-Bundle will be returned to the requesting entity. This Bundle will contain the full URLs of the sourced information, an Organization resource, and any matched Patient resources. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [FAST Identity UDAP Person](StructureDefinition-FASTIDUDAPPerson.md) | Profile on Person for use with the Interoperable Digital Identity and Patient Matching IG |
| [IDI Match Bundle](StructureDefinition-idi-match-bundle.md) | Bundle requirements for responders to an $IDI-match request. Responders**SHALL**include only absolute URL FHIR server addresses, and**SHALL NOT**include URIs for UUIDs or OIDs, in the fullURL returned. This additional constraint on a response to $IDI-match is intended to help recipients understand the source of the response, particularly when a patient match is invoked as part of record location–such that the URL would be needed for additional health data requests performed subsequent to matching. Additionally, the .identifier.assigner element within the returned Bundle**SHOULD**include an Organization resource that contains at least one appropriate contact point. |
| [IDI Match Input Parameters](StructureDefinition-idi-match-input-parameters.md) | The Parameters profile used to define the inputs of the $IDI-match operation using an IDI-Patient profile for submission. |
| [IDI Match Output Parameters](StructureDefinition-idi-match-output-parameters.md) | The Parameters profile used to define the outputs of the $IDI-match operation. |
| [IDI Patient](StructureDefinition-IDI-Patient.md) | (Base Level) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation. Only requires that 'some valuable data' be populated within the Patient resource and utilizes no weighting of element values. |
| [IDI Patient L0](StructureDefinition-IDI-Patient-L0.md) | (Level 0 weighting) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements which, when consistent with an identity verification event performed at IDIAL1.5 or higher, meet a combined 'weighted level' of at least 9 |
| [IDI Patient L1](StructureDefinition-IDI-Patient-L1.md) | (Level 1 weighting) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements which, when consistent with an identity verification event performed at IDIAL1.8 or higher, meet a combined 'weighted level' of at least 10 |
| [IDI Patient L2](StructureDefinition-IDI-Patient-L2.md) | (Level 2 weighting) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation, and prescribe a minimum set of data elements which, when consistent with an identity verification event performed at IAL2/IDIAL2 or higher, meet a combined 'weighted level' of at least 10 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Identity Identifier Value Set](ValueSet-Identity-Identifier-vs.md) | Codes describing various identifiers to be used in Patient resource for $idi-match. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Identity Identifier Code System](CodeSystem-Identity-Identifier-cs.md) | Defining codes for describing specialized identifiers to be used in Patient resource for $idi-match. |

### Terminology: Naming Systems 

These define identifier and/or code system identities used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Identity-HL7-Person-Identifier](NamingSystem-Identity-HL7-Person-Identifier.md) | Digital Identifier to assist in patient matching. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [FASTIDUDAPPerson-Example](Person-FASTIDUDAPPerson-Example.md) | Example of Person profile for use with the Interoperable Digital Identity and Patient Matching |
| [IDIMatchInputParameters-Example](Parameters-IDIMatchInputParameters-Example.md) | Example of IDI-Patient profile for submission as input parameter for $IDI-match operation |
| [IDIMatchOutputParameters-Example](Parameters-IDIMatchOutputParameters-Example.md) | Example of IDI-Patient profile for used to define the outputs of the $IDI-match operation |
| [MATCHOperationResponse](Bundle-MATCHOperationResponse.md) | Example of $IDI-match operation response with patient and organization |
| [Patient-INCOMPLETE](Patient-ExamplePatientINCOMPLETE.md) | Example of Patient used as input to $IDI-match operation but NOT meeting Level 0, 1, OR 2 information conformance; due to partial street address, missing DL assigner, and missing first name, this example incorrectly asserts L1 and would have a match input score of only 6, amounting to insufficient data for even a B2B match |
| [Patient-L0](Patient-ExamplePatientL0.md) | Example of Patient used as input to $IDI-match operation meeting Level 0 information conformance |
| [Patient-L1](Patient-ExamplePatientL1.md) | Example of Patient used as input to $IDI-match operation meeting Level 1 information conformance |
| [Patient-L2](Patient-ExamplePatientL2.md) | Example of Patient used as input to $IDI-match operation meeting Level 2 information conformance |
| [Patient1](Patient-ExamplePatient.md) | Example of Patient used as input to $IDI-match operation |
| [abc-hospital](Organization-abc-hospital.md) | Example hospital as Organization issuing a Digital Identifier |
| [def-idp](Organization-def-idp.md) | Example of Organization used as an identity provider for digital identifier |
| [patient-authorized-representative](RelatedPerson-patient-authorized-representative.md) | Example of a Patient who has been assigned a Digital Identifier, and is the authorized representative of another Patient. NOTE: Determining the nature of the authorized representative relationship and, ultimately, user authorization, is out of scope for this implementation guide. However, this example illustrates the demographics and identifiers that might be used to match on these individuals' identities assuming the authorized representative status can be confirmed. This expression of an authorized representative is therefore not intended to be normative, and feedback on preferred alternative approaches is encouraged. |
| [patient-multi-digital-identifier](Patient-patient-multi-digital-identifier.md) | Example of Patient where the individual has mulitple Digital Identifiers assigned to them from three different entities: a hospital, a payer, and an IdP. |
| [xyz-payer](Organization-xyz-payer.md) | Example payer as Organization issuing a Digital Identifier |

