# Identity Identifier Value Set - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identity Identifier Value Set**

## ValueSet: Identity Identifier Value Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/ValueSet/Identity-Identifier-vs | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IdentityIdentifierValueSet |

 
Codes describing various identifiers to be used in Patient resource for $idi-match. 

 **References** 

* [IDI Patient](StructureDefinition-IDI-Patient.md)
* [IDI Patient L0](StructureDefinition-IDI-Patient-L0.md)
* [IDI Patient L1](StructureDefinition-IDI-Patient-L1.md)
* [IDI Patient L2](StructureDefinition-IDI-Patient-L2.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "Identity-Identifier-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/ValueSet/Identity-Identifier-vs",
  "version" : "2.0.0",
  "name" : "IdentityIdentifierValueSet",
  "title" : "Identity Identifier Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "Codes describing various identifiers to be used in Patient resource for $idi-match.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/us/identity-matching/CodeSystem/Identity-Identifier-cs"
      },
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/identifier-type"]
      }
    ]
  }
}

```
