# IDI Match Output Parameters - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDI Match Output Parameters**

## Resource Profile: IDI Match Output Parameters 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-output-parameters | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IDIMatchOutputParameters |

 
The Parameters profile used to define the outputs of the $IDI-match operation. 

**Usages:**

* Examples for this Profile: [Parameters/IDIMatchOutputParameters-Example](Parameters-IDIMatchOutputParameters-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.identity-matching|current/StructureDefinition/idi-match-output-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-idi-match-output-parameters.csv), [Excel](StructureDefinition-idi-match-output-parameters.xlsx), [Schematron](StructureDefinition-idi-match-output-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "idi-match-output-parameters",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-output-parameters",
  "version" : "2.0.0",
  "name" : "IDIMatchOutputParameters",
  "title" : "IDI Match Output Parameters",
  "status" : "active",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "The Parameters profile used to define the outputs of the $IDI-match operation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "description" : "Slice based on $this pattern",
          "rules" : "open"
        },
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:IDIMatchBundle",
        "path" : "Parameters.parameter",
        "sliceName" : "IDIMatchBundle",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:IDIMatchBundle.name",
        "path" : "Parameters.parameter.name",
        "fixedString" : "IDIMatchBundle"
      },
      {
        "id" : "Parameters.parameter:IDIMatchBundle.resource",
        "path" : "Parameters.parameter.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Bundle",
            "profile" : [
              "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-bundle"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
