# IDI Match Input Parameters - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDI Match Input Parameters**

## Resource Profile: IDI Match Input Parameters 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-input-parameters | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IDIMatchInputParameters |

 
The Parameters profile used to define the inputs of the $IDI-match operation using an IDI-Patient profile for submission. 

**Usages:**

* Examples for this Profile: [Parameters/IDIMatchInputParameters-Example](Parameters-IDIMatchInputParameters-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.identity-matching|current/StructureDefinition/idi-match-input-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-idi-match-input-parameters.csv), [Excel](StructureDefinition-idi-match-input-parameters.xlsx), [Schematron](StructureDefinition-idi-match-input-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "idi-match-input-parameters",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-input-parameters",
  "version" : "2.0.0",
  "name" : "IDIMatchInputParameters",
  "title" : "IDI Match Input Parameters",
  "status" : "active",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "The Parameters profile used to define the inputs of the $IDI-match operation using an IDI-Patient profile for submission.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "description" : "Slice based on $this pattern",
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:IDIPatient",
        "path" : "Parameters.parameter",
        "sliceName" : "IDIPatient",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:IDIPatient.name",
        "path" : "Parameters.parameter.name",
        "patternString" : "IDIPatient"
      },
      {
        "id" : "Parameters.parameter:IDIPatient.resource",
        "path" : "Parameters.parameter.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient",
              "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L0",
              "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L1",
              "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L2"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:onlySingleMatch",
        "path" : "Parameters.parameter",
        "sliceName" : "onlySingleMatch",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:onlySingleMatch.name",
        "path" : "Parameters.parameter.name",
        "fixedString" : "onlySingleMatch"
      },
      {
        "id" : "Parameters.parameter:onlySingleMatch.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:onlySingleMatch.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:onlyCertainMatches",
        "path" : "Parameters.parameter",
        "sliceName" : "onlyCertainMatches",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:onlyCertainMatches.name",
        "path" : "Parameters.parameter.name",
        "fixedString" : "onlyCertainMatches"
      },
      {
        "id" : "Parameters.parameter:onlyCertainMatches.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:onlyCertainMatches.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:count",
        "path" : "Parameters.parameter",
        "sliceName" : "count",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:count.name",
        "path" : "Parameters.parameter.name",
        "fixedString" : "count"
      },
      {
        "id" : "Parameters.parameter:count.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:count.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      }
    ]
  }
}

```
