# IDI Patient - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDI Patient**

## Resource Profile: IDI Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IDIPatient |

 
(Base Level) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation. Only requires that 'some valuable data' be populated within the Patient resource and utilizes no weighting of element values. 

**Usages:**

* Use this Profile: [IDI Match Input Parameters](StructureDefinition-idi-match-input-parameters.md)
* Examples for this Profile: [Patient/ExamplePatient](Patient-ExamplePatient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.identity-matching|current/StructureDefinition/IDI-Patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IDI-Patient.csv), [Excel](StructureDefinition-IDI-Patient.xlsx), [Schematron](StructureDefinition-IDI-Patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IDI-Patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient",
  "version" : "2.0.0",
  "name" : "IDIPatient",
  "title" : "IDI Patient",
  "status" : "active",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "(Base Level) The goal of this profile is to describe a data-minimized version of Patient used to convey information about the patient for Identity Matching utilizing the $idi-match operation.  Only requires that 'some valuable data' be populated within the Patient resource and utilizes no weighting of element values.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Patient information to be supplied to $match operation",
        "definition" : "Demographics and other administrative information about an individual which can be utilized within the $match operation.",
        "constraint" : [
          {
            "key" : "idi-1",
            "severity" : "error",
            "human" : "One of identifier or telecom or family and given names or address or birthdate SHALL be present",
            "expression" : "identifier.exists() or telecom.exists() or (name.family.exists() and name.given.exists()) or (address.line.exists() and address.city.exists()) or birthDate.exists()",
            "source" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient"
          }
        ]
      },
      {
        "id" : "Patient.meta.profile",
        "path" : "Patient.meta.profile",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on pattern",
          "ordered" : false,
          "rules" : "open"
        },
        "comment" : "meta.profile is required as a matter of convenience of receiving systems. The meta.profile SHALL be used by the Server to hint/assert/declare that this instance conforms to the stated profiles (with business versions). meta.profile does not capture any business logic, processing directives, or semantics (for example, inpatient or outpatient). "
      },
      {
        "id" : "Patient.meta.profile:assertedProfile",
        "path" : "Patient.meta.profile",
        "sliceName" : "assertedProfile",
        "min" : 0,
        "max" : "1",
        "patternCanonical" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient"
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/identity-matching/ValueSet/Identity-Identifier-vs"
        }
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "constraint" : [
          {
            "key" : "idi-2",
            "severity" : "error",
            "human" : "Either the given or family name SHALL be present",
            "expression" : "given.exists() or family.exists()",
            "source" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient"
          }
        ]
      }
    ]
  }
}

```
