# FAST Identity UDAP Person - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FAST Identity UDAP Person**

## Resource Profile: FAST Identity UDAP Person 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/StructureDefinition/FASTIDUDAPPerson | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:FASTIDUDAPPerson |

 
Profile on Person for use with the Interoperable Digital Identity and Patient Matching IG 

**Usages:**

* Examples for this Profile: [Person/FASTIDUDAPPerson-Example](Person-FASTIDUDAPPerson-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.identity-matching|current/StructureDefinition/FASTIDUDAPPerson)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-FASTIDUDAPPerson.csv), [Excel](StructureDefinition-FASTIDUDAPPerson.xlsx), [Schematron](StructureDefinition-FASTIDUDAPPerson.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "FASTIDUDAPPerson",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/FASTIDUDAPPerson",
  "version" : "2.0.0",
  "name" : "FASTIDUDAPPerson",
  "title" : "FAST Identity UDAP Person",
  "status" : "active",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "Profile on Person for use with the Interoperable Digital Identity and Patient Matching IG",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Person",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Person",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Person",
        "path" : "Person"
      },
      {
        "id" : "Person.name.family",
        "path" : "Person.name.family",
        "min" : 1
      },
      {
        "id" : "Person.name.given",
        "path" : "Person.name.given",
        "min" : 1
      },
      {
        "id" : "Person.telecom",
        "path" : "Person.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "description" : "Forcing both a phone and an email contact",
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Person.telecom:tphone",
        "path" : "Person.telecom",
        "sliceName" : "tphone",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Person.telecom:tphone.system",
        "path" : "Person.telecom.system",
        "min" : 1,
        "patternCode" : "phone"
      },
      {
        "id" : "Person.telecom:email",
        "path" : "Person.telecom",
        "sliceName" : "email",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Person.telecom:email.system",
        "path" : "Person.telecom.system",
        "min" : 1,
        "patternCode" : "email"
      },
      {
        "id" : "Person.birthDate",
        "path" : "Person.birthDate",
        "min" : 1
      },
      {
        "id" : "Person.address.line",
        "path" : "Person.address.line",
        "min" : 1
      },
      {
        "id" : "Person.address.city",
        "path" : "Person.address.city",
        "min" : 1
      },
      {
        "id" : "Person.address.state",
        "path" : "Person.address.state",
        "min" : 1
      },
      {
        "id" : "Person.address.postalCode",
        "path" : "Person.address.postalCode",
        "min" : 1
      }
    ]
  }
}

```
