# patient-authorized-representative - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **patient-authorized-representative**

## Example RelatedPerson: patient-authorized-representative

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core RelatedPerson Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-relatedperson.html)

**identifier**: [HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md)/927398f0-d506-443b-b731-fa09869625e3

**active**: true

**patient**: [Honk Huberdeau Male, DoB: 1980-01-10 ( http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier#HL7PersonIdentifier#a5c2498f-9b62-4c97-8dc3-03a20b0f5412)](Patient-patient-multi-digital-identifier.md)

**relationship**: HIPAA Authorized Representative

**name**: Henrietta Huberdeau 

**telecom**: ph: 555-978-3349(Home), [etta.huberdeau@example.com](mailto:etta.huberdeau@example.com)

**address**: 999 Not Real Street Columbus OH 43210 US 



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "patient-authorized-representative",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "927398f0-d506-443b-b731-fa09869625e3",
      "assigner" : {
        "reference" : "Organization/abc-hospital"
      }
    }
  ],
  "active" : true,
  "patient" : {
    "reference" : "Patient/patient-multi-digital-identifier"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction",
          "code" : "AUTM"
        }
      ],
      "text" : "HIPAA Authorized Representative"
    }
  ],
  "name" : [
    {
      "family" : "Huberdeau",
      "given" : ["Henrietta"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-978-3349",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "etta.huberdeau@example.com"
    }
  ],
  "address" : [
    {
      "line" : ["999 Not Real Street"],
      "city" : "Columbus",
      "state" : "OH",
      "postalCode" : "43210",
      "country" : "US"
    }
  ]
}

```
