# FASTIDUDAPPerson-Example - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FASTIDUDAPPerson-Example**

## Example Person: FASTIDUDAPPerson-Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [FAST Identity UDAP Person](StructureDefinition-FASTIDUDAPPerson.md)

**name**: Peter James Chalmers (Official)

**telecom**: ph: (03) 5555 6473(Work), [Jim@example.org](mailto:Jim@example.org)

**birthDate**: 1974-12-25

**address**: 534 Erewhon St PleasantVille Vic 3999 (work)



## Resource Content

```json
{
  "resourceType" : "Person",
  "id" : "FASTIDUDAPPerson-Example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/FASTIDUDAPPerson"
    ]
  },
  "name" : [
    {
      "use" : "official",
      "family" : "Chalmers",
      "given" : ["Peter", "James"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5555 6473",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "Jim@example.org",
      "use" : "work"
    }
  ],
  "birthDate" : "1974-12-25",
  "address" : [
    {
      "use" : "work",
      "line" : ["534 Erewhon St"],
      "city" : "PleasantVille",
      "state" : "Vic",
      "postalCode" : "3999"
    }
  ]
}

```
