# patient-multi-digital-identifier - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **patient-multi-digital-identifier**

## Example Patient: patient-multi-digital-identifier

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Patient Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)

Honk Huberdeau Male, DoB: 1980-01-10 ( http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier#HL7PersonIdentifier#a5c2498f-9b62-4c97-8dc3-03a20b0f5412)

-------

| | |
| :--- | :--- |
| Active: | true |
| Other Ids: | * [HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md)/40e31ed2-4d16-4416-a66d-c3e84f8a4812
* [HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md)/db0cfc86-58e4-467c-b1d7-78571598ee15
 |
| Contact Detail | * ph: 555-555-5555(Home)
* [honk.huberdeau@example.com](mailto:honk.huberdeau@example.com)
* 999 Not Real Street Columbus OH 43210 US 
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "patient-multi-digital-identifier",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "a5c2498f-9b62-4c97-8dc3-03a20b0f5412",
      "assigner" : {
        "reference" : "Organization/abc-hospital"
      }
    },
    {
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "40e31ed2-4d16-4416-a66d-c3e84f8a4812",
      "assigner" : {
        "reference" : "Organization/xyz-payer"
      }
    },
    {
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "db0cfc86-58e4-467c-b1d7-78571598ee15",
      "assigner" : {
        "reference" : "Organization/def-idp"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Huberdeau",
      "given" : ["Honk"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "honk.huberdeau@example.com"
    }
  ],
  "gender" : "male",
  "birthDate" : "1980-01-10",
  "address" : [
    {
      "line" : ["999 Not Real Street"],
      "city" : "Columbus",
      "state" : "OH",
      "postalCode" : "43210",
      "country" : "US"
    }
  ]
}

```
