# Patient-L2 - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient-L2**

## Example Patient: Patient-L2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Language: en-US

Profile: [IDI Patient L2](StructureDefinition-IDI-Patient-L2.md)

Teddy Cheze Male, DoB: 1980-05-05 ( Driver's license number)

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Marital Status: | unknown |
| Other Id: | Person number/0000-000-0000-00000000000 | | |
| Contact Detail | * ph: 726-999-1990(Mobile)
* 123 High Street Raleigh NC 27513 
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ExamplePatientL2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient-L2"
    ]
  },
  "language" : "en-US",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "DL"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/NamingSystem/NorthCarolinaDLN",
      "value" : "3955-56122846",
      "assigner" : {
        "display" : "North Carolina"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "0000-000-0000-00000000000"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Cheze",
      "given" : ["Teddy"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "726-999-1990",
      "use" : "mobile"
    }
  ],
  "gender" : "male",
  "birthDate" : "1980-05-05",
  "address" : [
    {
      "type" : "physical",
      "line" : ["123 High Street"],
      "city" : "Raleigh",
      "state" : "NC",
      "postalCode" : "27513"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "code" : "UNK"
      }
    ]
  }
}

```
