# IDIMatchInputParameters-Example - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDIMatchInputParameters-Example**

## Example Parameters: IDIMatchInputParameters-Example



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "IDIMatchInputParameters-Example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-input-parameters"
    ]
  },
  "parameter" : [
    {
      "name" : "IDIPatient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "ExamplePatient",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/identity-matching/StructureDefinition/IDI-Patient"
          ]
        },
        "language" : "en-US",
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MB"
                }
              ]
            },
            "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
            "value" : "1234-234-1243-12345678901"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Beegood",
            "given" : ["Johnny"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "301-555-2112",
            "use" : "mobile"
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-05-01",
        "address" : [
          {
            "type" : "physical",
            "line" : ["123 Main Street"],
            "city" : "Pittsburgh",
            "state" : "PA",
            "postalCode" : "12519"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "UNK"
            }
          ]
        }
      }
    },
    {
      "name" : "onlySingleMatch",
      "valueBoolean" : true
    }
  ]
}

```
