# xyz-payer - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **xyz-payer**

## Example Organization: xyz-payer

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**identifier**: [HL7PersonIdentifier](NamingSystem-Identity-HL7-Person-Identifier.md)/666666

**name**: XYZ Insurance

**alias**: XYZ

> **contact****telecom**:[+1 555 234 3523](tel:+15552343523),[info@xyz-payer.org](mailto:info@xyz-payer.org)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "xyz-payer",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/us/identity-matching/ns/HL7PersonIdentifier",
      "value" : "666666"
    }
  ],
  "name" : "XYZ Insurance",
  "alias" : ["XYZ"],
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+1 555 234 3523",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "info@xyz-payer.org",
          "use" : "work"
        }
      ]
    }
  ]
}

```
