# abc-hospital - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **abc-hospital**

## Example Organization: abc-hospital

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**identifier**: `http://example.org/fhir/endpoint/`/91654 (use: official, ), `http://example.org/fhir/endpoint/`/17-0112278 (use: usual, )

**name**: Burgers University Medical Center

> **contact****telecom**: ph: 022-655 2300(Work)

> **contact****address**: Galapagosweg 91 Den Burg 9105 PZ NLD (work)

> **contact****address**: PO Box 2311 Den Burg 9100 AA NLD (work)

> **contact****telecom**: ph: 022-655 2334

> **contact****telecom**: ph: 022-655 2335



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "abc-hospital",
  "identifier" : [
    {
      "use" : "official",
      "system" : "http://example.org/fhir/endpoint/",
      "value" : "91654"
    },
    {
      "use" : "usual",
      "system" : "http://example.org/fhir/endpoint/",
      "value" : "17-0112278"
    }
  ],
  "name" : "Burgers University Medical Center",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "022-655 2300",
          "use" : "work"
        }
      ]
    },
    {
      "address" : {
        "use" : "work",
        "line" : ["Galapagosweg 91"],
        "city" : "Den Burg",
        "postalCode" : "9105 PZ",
        "country" : "NLD"
      }
    },
    {
      "address" : {
        "use" : "work",
        "line" : ["PO Box 2311"],
        "city" : "Den Burg",
        "postalCode" : "9100 AA",
        "country" : "NLD"
      }
    },
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "022-655 2334"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "022-655 2335"
        }
      ]
    }
  ]
}

```
