# IDI Match Operation - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IDI Match Operation**

## OperationDefinition: IDI Match Operation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/OperationDefinition/IDI-match | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IDIMatch |

 
This extension of the $match operation is further constrained to meet the additional requirements found in this IG. One of the IDI Patient profiles outline in this guide (IDI-Patient, IDI-Patient-L0, IDI-Patient-L1, IDI-Patient-L2)**SHALL**be used as the input for the match request. An IDI-Match-Bundle will be returned to the requesting entity. This Bundle will contain the full URLs of the sourced information, an Organization resource, and any matched Patient resources. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "IDI-match",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/OperationDefinition/IDI-match",
  "version" : "2.0.0",
  "name" : "IDIMatch",
  "title" : "IDI Match Operation",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "This extension of the $match operation is further constrained to meet the additional requirements found in this IG. One of the IDI Patient profiles outline in this guide (IDI-Patient, IDI-Patient-L0, IDI-Patient-L1, IDI-Patient-L2) **SHALL** be used as the input for the match request. An IDI-Match-Bundle will be returned to the requesting entity. This Bundle will contain the full URLs of the sourced information, an Organization resource, and any matched Patient resources.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "idi-match",
  "base" : "http://hl7.org/fhir/OperationDefinition/Patient-match",
  "system" : false,
  "type" : true,
  "instance" : false,
  "inputProfile" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-input-parameters",
  "outputProfile" : "http://hl7.org/fhir/us/identity-matching/StructureDefinition/idi-match-output-parameters",
  "parameter" : [
    {
      "name" : "IDIPatient",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "A Patient resource that is being requested in the match operation. The requester **SHALL** use one of the IDI Patient profiles for the resource in their submission.",
      "type" : "Patient"
    },
    {
      "name" : "onlySingleMatch",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "If there are multiple potential matches, the server should identify the single most appropriate match that should be used with future interactions with the server (for example, as part of a subsequent create interaction).",
      "type" : "boolean"
    },
    {
      "name" : "onlyCertainMatches",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "If there are multiple potential matches, the server should be certain that each of the records are for the same patients. This could happen if the records are duplicates, are the same person for the purpose of data segregation, or other reasons. When false, the server may return multiple results with each result graded accordingly.",
      "type" : "boolean"
    },
    {
      "name" : "count",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The maximum number of records to return. If no value is provided, the server decides how many matches to return. Note that clients should be careful when using this, as it may prevent probable - and valid - matches from being returned.",
      "type" : "integer"
    },
    {
      "name" : "IDIMatchBundle",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "When successful, a Bundle resource containing Patient resources of a high confidence match **SHALL** be returned to the requestor. In addition, an Organization resource of the responding entity **SHALL** be included in the Bundle for error reporting purposes. When the responding server is unable to return a match, a response of 'No Match Found' will be returned.",
      "type" : "Bundle"
    }
  ]
}

```
