# Identity Identifier Code System - Interoperable Digital Identity and Patient Matching v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identity Identifier Code System**

## CodeSystem: Identity Identifier Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/identity-matching/CodeSystem/Identity-Identifier-cs | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:IdentityIdentifierCodeSystem |

 
Defining codes for describing specialized identifiers to be used in Patient resource for $idi-match. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [IdentityIdentifierValueSet](ValueSet-Identity-Identifier-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "Identity-Identifier-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/identity-matching/ImplementationGuide/hl7.fhir.us.identity-matching"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/identity-matching/CodeSystem/Identity-Identifier-cs",
  "version" : "2.0.0",
  "name" : "IdentityIdentifierCodeSystem",
  "title" : "Identity Identifier Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-10T16:42:49+00:00",
  "publisher" : "HL7 International / Patient Administration",
  "contact" : [
    {
      "name" : "HL7 International / Patient Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pafm"
        }
      ]
    }
  ],
  "description" : "Defining codes for describing specialized identifiers to be used in Patient resource for $idi-match.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "STID",
      "display" : "State Level Identifier",
      "definition" : "Represents any appropriate identifier corresponding to a state- or territory-issued photo ID that is not a Driver's License. This code will likely be migrated to THO at some point in the future."
    },
    {
      "code" : "SSN4",
      "display" : "SSN Last 4",
      "definition" : "Represents the last four digits of US Social Security Number. This code may be migrated to THO at some point in the future."
    }
  ]
}

```
