<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CQMComputableMeasure
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Measure</sch:title>
    <sch:rule context="f:Measure">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringUnit']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringUnit': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringPrecision']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringPrecision': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:group) &gt;= 1">group: minimum cardinality of 'group' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group</sch:title>
    <sch:rule context="f:Measure/f:group">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-populationBasis']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-populationBasis': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringUnit']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringUnit': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringPrecision']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-scoringPrecision': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-compositeScoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-compositeScoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-riskAdjustment']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-riskAdjustment': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-rateAggregation']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-rateAggregation': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-improvementNotation']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-improvementNotation': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group/f:population</sch:title>
    <sch:rule context="f:Measure/f:group/f:population">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.population.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/cqf-criteriaReference': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-aggregateMethod']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-aggregateMethod': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group/f:stratifier</sch:title>
    <sch:rule context="f:Measure/f:group/f:stratifier">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.stratifier.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.stratifier.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group/f:stratifier/f:component</sch:title>
    <sch:rule context="f:Measure/f:group/f:stratifier/f:component">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.stratifier.component.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.group.stratifier.component.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:supplementalData</sch:title>
    <sch:rule context="f:Measure/f:supplementalData">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.supplementalData.linkId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-Measure.supplementalData.linkId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/cqm/StructureDefinition/cqm-valueSet': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
