#### Quality Improvement Ecosystem
{: #quality-improvement-ecosystem}

The diagram below shows the quality improvement ecosystem.  Each step is discussed in the following order:<br>
<br>
Step 1: Researcher and public health surveillance – begins with information, preferably evidence-based from research, public health surveillance, and data mining and other analyses performed by third parties such as academic institutions or payers. Such information indicates existing status and knowledge about a given clinical topic.<br>
<br>
Step 2: Clinical practice guidelines – stakeholders, such as professional societies, public health agencies, and governmental bodies, publish such information to provide current recommendations to consumers, healthcare practitioners, and healthcare organizations about what is known and suggested methods for managing the clinical topic. Ideally, suggested management efforts are captured and documented in guidelines based on collaboration among clinical subject matter experts, terminologists, informaticists, clinicians and consumers.<br>
<br>
Step 3: Clinical decision support - the clinical guidelines developed in step 2 are translated into clinical decision support (CDS) artifacts to incorporate relevant, evidence-based, and patient-specific clinical recommendations and actions directly within clinical workflow.<br>
<br>
Step 4: Clinical Care - To adequately impact clinical care for clinicians and patients requires local implementation activities as shown in CDS is not intended to replace clinician judgment, but rather to provide information to assist care team members in managing the complex and expanding volume of biomedical and person-specific data needed to make timely, informed, and higher quality decisions based on current clinical science. Ideally, the clinical guidelines and CDS include methods for evaluating what successful implementation means, (i.e., whether the clinical care ultimately provided included processes that addressed the intent of the guideline and if it achieved the desired outcomes). Further information on CDS and its optimization of care delivery can be found [here](https://www.healthit.gov/sites/default/files/page/2018-04/Optimizing_Strategies_508.pdf).<br>
<br>
Step 5: Measurement and Analytics – closes the loop and enables continuous improvement; the results of such measurement analytics must be reported for aggregate review.<br>
<br>
Step 6: Reporting – serves the purpose of evaluating clinical performance and outcomes, whether it be internally for healthcare organizations, or for third parties such as public health or for payers. Ultimately, this information may then serve as part of the evidence base shown in step 1.<br>

<details open>
<summary>

<b>Figure 1-1: The Quality Improvement Ecosystem Diagram</b>

</summary>

{% include img.html img="Export_new.png" %}

</details>

>Practitioner organizations along with stakeholders such as public health
have ongoing needs for quality improvement at the point of care. Every effort should be made to
establish a capable distributed rule processing environment in FHIR. For
additional information about idealized processes for moving evidence and
information from guidelines to CDS and measurement, refer to an effort by the
Centers for Disease Control and Prevention (CDC) called
[Adapting Clinical Guidelines for the Digital Age](https://journals.lww.com/ajmqonline/fulltext/2023/09002/adapting_clinical_guidelines_for_the_digital_age_.2.aspx).
