# CDS Hooks Card Profiles - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* **CDS Hooks Card Profiles**

## CDS Hooks Card Profiles

This page gives guidelines for populating and returning CDS Hooks response Cards in a REMS workflow.

[Cards](https://cds-hooks.hl7.org/2.0/#cds-service-response) are how REMS Administrator Systems return information and requested actions (e.g., launching a SMART app) to the provider in response to requests triggered during the prescriber’s workflow.

REMS Administrator Systems dynamically create these Cards for each CDS Hooks request based on conditions including:

* the prescribed drug’s REMS program
* the status of required REMS steps at the time of the event
* REMS information needs associated with the current point in the patient’s treatment
* the ability of the specified Pharmacy to dispense the desired REMS medication

This guidance is based on [the CDS Hooks specification](https://cds-hooks.hl7.org/2.0/#card-attributes) as applied to the REMS workflow. In addition, this guide aims to provide direction that is consistent with that given in the Da Vinci Coverage Requirements Discovery (CRD) IG to the extent possible (as described further [here](technical-background.md#consistency-with-the-da-vinci-burden-reduction-igs)).

### General Card Population Guidance

All Card types, including the Suggestion type containing a system Action as described in the [Deferred SMART Application Launch](#deferred-smart-application-launch-suggestion) section below, are presented to the provider within the workflow of their Provider System. They:

* display information
* offer links that the provider may follow to external information
* give the provider the option to complete a task by launching a SMART app immediately
* or give the provider the option to place the SMART app step in their work queue to be completed in the future.

In all cases, Cards interrupt the provider’s workflow and will be welcomed by the provider only when they are pertinent to the situation, when their benefit outweighs the disruption to the provider’s thought process, and when their content can be quickly understood and acted upon.

**General guidelines for a REMS Administrator System returning Cards:**

* The `Card.indicator` denotes the urgency or importance of what the Card conveys. It **SHOULD** be populated from the perspective of **clinical importance and/or risk** to the patient, versus importance from an administrative perspective. For example, while a REMS Administrator might perceive a provider not being registered for a REMS Program as very important and urgent from the perspective of being able to prescribe and dispense a REMS drug, it would be, at most, a `warning` to the user according to the conventions for presenting Cards. The indicator value, `critical`, must be reserved for reporting the risk of life or death or other serious clinical outcomes. Most REMS responses **SHOULD** be marked as `info`.
* The `Card.source.label` **SHOULD** be populated with the name of the REMS program that the user and patient would recognize.
* Because providers’ time is limited, information returned in Cards must be quickly understandable and pertinent to the request context, the current state of the patient’s treatment and the status of REMS requirements. Specifically:
* Provider Systems might not support all Card capabilities; therefore Card options **SHOULD** provide sufficient information for a user to take appropriate actions manually if automated support isn’t available.

### Potential REMS CDS Hooks Response Types

Note: While the Card types and content described below are what REMS Administrators will typically return in a REMS workflow, implementers are not limited to these options.

#### External Reference

This response type presents a Card with one or more links to external web pages, PDFs, or other resources that provide relevant information with regards to the REMS program the CDS Hook was executed for. A link might provide information about the program, requirements for safe use, printable forms, etc. Typically, these references would be links to information available from the REMS Administrator’s website or other authoritative sources. The Card **SHALL** have at least one `Card.link`. The `Link.type` **SHALL** have a type of “absolute”.

When reasonable, an “External Reference” Card **SHOULD** contain a summary of the actionable information from the external reference.

For example, this CDS Hooks [Card](https://cds-hooks.hl7.org/2.0/#cds-service-response) contains five [Links](https://cds-hooks.hl7.org/2.0/#link) - a link to an overview website, a link to a PDF containing a guide for the medication itself, a link to PDF that specifics the REMS program information, a link to a PDF that contains adverse event management and a link to a provider enrollment form.

```
{
  "uuid" : "urn:uuid:07bc9814-9d2a-11ee-8c90-0242ac120002",
  "summary" : "DRUG-X REMS Program and Requirements",
  "detail" : "Learn about the DRUG-X REMS Program and Requirements",
  "indicator" : "info",
  "source" : {
    "label" : "DRUG-X REMS Program Administrator",
    "url" : "https://example.org/DRUG-X",
    "topic" : {
      "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
      "code" : "guideline",
      "display" : "Guideline"
    }
  },
  "links" : [
    {
      "label" : "DRUG-X REMS Program Overview" ,
      "url" : "https://example.org/DRUG-X/Overview",
      "type" : "absolute"
    },
    {
      "label" : "DRUG-X REMS Medication Guide",
      "url" : "https://example.org/DRUG-X/MedicationGuide.pdf",
      "type" : "absolute"
    },
    {
      "label" : "DRUG-X REMS Program Requirements",
      "url" : "https://example.org/DRUG-X/RemsProgramRequirements.pdf",
      "type" : "absolute"
    },
    {
      "label" : "DRUG-X Adverse Reaction Management Guide",
      "url" : "https://example.org/DRUG-X/AdverseReactionManagment.pdf",
      "type" : "absolute"
    },
    {
      "label" : "Provider Enrollment Form",
      "url" : "https://example.org/DRUG-X/ProviderEnrollmentForm.pdf",
      "type" : "absolute"
    }
  ]
}
```

As much as technically possible, links provided **SHOULD** take the user to the specific place in the documentation relevant to the current hook context to minimize provider reading and navigation time.

#### Instructions

This response type presents a Card with textual guidance or instructions to display to the provider. The text might provide information related to updated REMS guidelines, notifying the user of a need to update a self-assessment or even something as simple as “No REMS requirements currently require action”.

Instructions **SHOULD** reflect the current status of the patient’s and provider’s participation in the REMS program–providing only applicable direction at the time of the request. The instruction text **SHOULD** be concise and simple for the provider to consume, omitting any general guidance that is not relevant to the situation. To accomplish this, the text returned might need to be generated uniquely each time a hook is fired.

Care should be taken not to overuse this return type with information that is not truly relevant.

This example CDS Hook [Card](https://cds-hooks.hl7.org/2.0/#cds-service-response) just contains a message:

```
{
  "summary" : "Provider Mary Zhang must re-enroll in the DRUG-X REMS program by December 15",
  "detail" : "Your enrollment in the DRUG-X REMS program must be renewed annually. The deadline for Mary Zhang MD is December 15",
  "indicator" : "info",
  "source" : {
    "label" : "DRUG-X Rems Program",
    "url" : "https://example.org/DRUG-X",
    "icon" : "https://example.org/img/icon-100px.png"
  }
}
```

#### Launch SMART application

Unlike External References, SMART (Substitutable Medical Applications, Reusable Technologies) apps can be launched within the Provider System workflow and use data from the Provider System to support their features. They allow interaction between the REMS Administrator and Provider System and can be authorized to access patient clinical data to help guide the interactive experience and minimize data entry. Apps can provide a wide variety of functions in the REMS workflow, including patient enrollment, providing education, collecting periodic clinical information required by the REMS, etc.

Card population for this response type is similar to the [External Reference](#external-reference) response type, except with the `Link.type` set to “smart” instead of “absolute”. The `Link.appContext` will typically also be present, providing context information that is useful to the app, which will be included when the EHR launches it.

For example, the Card below contains a SMART App [Link](https://cds-hooks.hl7.org/2.0/#link) to enroll the patient into the REMS program:

```
{
  "uuid" : "urn:uuid:353cd963-2ecd-46f9-958b-ed7d2bbf6e01",
  "summary" : "Launch DRUG-X REMS Patient Enrollment App",
  "indicator" : "info",
  "source" : {
    "label" : "DRUG-X REMS Administrator",
    "url" : "https://example.org/DRUG-X",
    "icon" : "https://example.org/img/icon-100px.png"
  },
  "links" : [
    {
      "label" : "DRUG-X REMS Patient Enrollment Application",
      "url" : "https://example.org/DRUG-X/smart-app",
      "type" : "smart",
      "appContext" : "{\"providerSystemPatientId\":\"123\"}"
    }
  ]
}
```

**Note regarding app registration.** To be made available to providers within a Provider System, SMART apps need to first be approved by the provider organization and, typically, also the associated software vendor.

#### Deferred SMART Application Launch Suggestion

This response type can be used to present a Card that indicates there is a SMART application that can be launched at a future time to satisfy a REMS step. A recommended use within the REMS workflow is to defer launching of a SMART app for enrolling the provider or patient into the REMS program.

This is accomplished by including a `suggestion` within a CDS Card that includes a `create` action for a Task resource.

Note that this `suggestion` may reside within the same Card that contains a `link` to launch the app immediately, giving the provider a choice of launching the app now or later.

The Task resource:

* is based on either the [Task EHR Launch](https://hl7.org/fhir/smart-app-launch/StructureDefinition-task-ehr-launch.html) or [Task EHR Standalone](https://hl7.org/fhir/smart-app-launch/StructureDefinition-task-standalone-launch.html) profiles from the [SMART App Launch IG](https://hl7.org/fhir/smart-app-launch)
* has a `Task.code` of either `launch-app-ehr` or `launch-app-standalone`
* points to the SMART application to launch using a `Task.input` element with a `Task.input.type.coding.code` value of `smartonfhir-application`
* includes an additional `Task.input` element with a `Task.input.type.coding.code` of `smartonfhir-appcontext` which will hold the application context to use to launch the SMART application with.

This guide defines a [Task profile which further tailors the resource for use in the REMS workflow](StructureDefinition-medication-rems-task-smart-launch.md).

The example below shows a CDS Hook [Suggestion](https://cds-hooks.hl7.org/2.0/#suggestion) containing a SMART application launch Task as the Card’s [Action](https://cds-hooks.hl7.org/2.0/#action).

```
{
  "uuid" : "urn:uuid:353cd963-2ecd-46f9-958b-ed7d2bbf6e01",
  "summary" : "Defer DRUG-X patient enrollment until later,
  "indicator" : "info",
  "source" : {
    "label" : "DRUG-X REMS Administrator",
    "url" : "https://example.org/DRUG-X",
    "icon" : "https://example.org/img/icon-100px.png"
  },
  "suggestions" : {
    "label" : "Put the DRUG-X enrollment app in your work queue to complete later",
    "actions" : [
      {
        "type" : "create",
        "description" : "Add deferred SMART Launch for DRUG-X to the work queue",
        "resource" : {
          "resourceType" : "Task",
          "status" : "requested",
          "intent" : "proposal",
          "code" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
                "code" : "launch-app-ehr",
                 "display" : "Launch application using the SMART EHR launch"
              }
            ]
          },
          "description" : "Complete DRUG-X REMS enrollment",
          "for" : {
            "reference" : "http://example.org/fhir/Patient/123"
          },
          "authoredOn" : "2024-02-13",
          "requester" : {
            "reference" : "http://example.org/fhir/Organization/rems-administrator/100",
            "display" : "DRUG-X REMS Administrator"        
          },
          "input" : [
            {
              "type" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
                    "code" : "smartonfhir-application",
                    "display" : "SMART on FHIR application URL."
                  }
                ]
              },
              "valueString" : "https://example.org/DRG-X/smart-application"
            },
            {
              "type" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
                    "code" : "smartonfhir-appcontext",
                    "display" : "Application context related to this launch."                  
                   }
                 ]
               },
               "valueString" : "{\"providerSystemPatientId\":\"123\"}"
            }
          ]
        }
      }
    ]
  }
}

```

