# Medication REMS Capability Statement - REMS Administrator System - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication REMS Capability Statement - REMS Administrator System**

## CapabilityStatement: Medication REMS Capability Statement - REMS Administrator System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/medication-rems/CapabilityStatement/rems-administrator-system | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:MedicationRemsCapabilityStatementRemsAdministratorSystem |

 
This CapabilityStatement describes the expected capabilities of a REMS Administrator System that conforms to the conventions of the Medication REMS FHIR implementation guide. 

 [Raw OpenAPI-Swagger Definition file](rems-administrator-system.openapi.json) | [Download](rems-administrator-system.openapi.json) 

## Medication REMS Capability Statement - REMS Administrator System

* Implementation Guide Version: 2.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `xml`, `json`
* Supported Patch Formats: `application/json-patch+json`
* Published on: 2024-04-01 00:00:00-0500 
* Published by: HL7 International / Pharmacy 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html)

### SHOULD Support the Following Implementation Guides

* [http://cds-hooks.hl7.org/ImplementationGuide/hl7.fhir.uv.cds-hooks](http://cds-hooks.hl7.org/STU2/index.html)

## FHIR RESTful Capabilities

### Mode: server

When participating in exchanges described in the Medication REMS FHIR IG, the REMS Administrator System **SHALL** 1. Implement RESTful behavior according to the FHIR specification. 2. Support the JSON source format. When participating in exchanges described in the Medication REMS FHIR IG, the REMS Administrator System **SHOULD**: 1. Support the XML source format.

**Security**

> 

1. Communication security implemented by the REMS Administrator System SHALL conform with the guidelines stated in[FHIR Security](https://www.hl7.org/fhir/security.html)for all exchanges covered in this IG. 2. For general security considerations refer to[FHIR Security and Privacy Considerations](https://www.hl7.org/fhir/secpriv-module.html).




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "rems-administrator-system",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/medication-rems/ImplementationGuide/hl7.fhir.us.medication-rems"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/medication-rems/ImplementationGuide/hl7.fhir.us.medication-rems"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/medication-rems/CapabilityStatement/rems-administrator-system",
  "version" : "2.0.0",
  "name" : "MedicationRemsCapabilityStatementRemsAdministratorSystem",
  "title" : "Medication REMS Capability Statement - REMS Administrator System",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-01T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "frank.mckinney@pocp.com"
        },
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the expected capabilities of a REMS Administrator System that conforms to the conventions of the Medication REMS FHIR implementation guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch",
    "http://cds-hooks.hl7.org/ImplementationGuide/hl7.fhir.uv.cds-hooks"
  ],
  "_implementationGuide" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHOULD"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "When participating in exchanges described in the Medication REMS FHIR IG, the REMS Administrator System **SHALL** 1. Implement RESTful behavior according to the FHIR specification. 2. Support the JSON source format. \nWhen participating in exchanges described in the Medication REMS FHIR IG, the REMS Administrator System **SHOULD**: 1. Support the XML source format.",
      "security" : {
        "description" : "1. Communication security implemented by the REMS Administrator System SHALL conform with the guidelines stated in [FHIR Security](https://www.hl7.org/fhir/security.html) for all exchanges covered in this IG. 2. For general security considerations refer to [FHIR Security and Privacy Considerations](https://www.hl7.org/fhir/secpriv-module.html)."
      }
    }
  ]
}

```
