# hl7.fhir.us.medication-rems#2.0.0: US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG

## Pages

* [REMS IG Home Page](index.md)
* [Artifacts Summary](artifacts.md)
* [CDS Hooks Card Profiles](cds-cards.md)
* [Change History](change-history.md)
* [Credits](credits.md)
* [Downloads](downloads.md)
* [REMS Interaction Events and Triggers](event-triggers.md)
* [Future Directions](future-directions.md)
* [REMS Steps and Terminology](process.md)
* [Participant Roles and Needs](roles.md)
* [Formal Specification](specification.md)
* [Technical Background](technical-background.md)
* [Use Cases](use-cases.md)

## Resources

### Resource Profiles

* [Medication REMS Task - SMART Launch](StructureDefinition-medication-rems-task-smart-launch.md)

### CapabilityStatements

* [Medication REMS Capability Statement - Provider System](CapabilityStatement-provider-system.md)
* [Medication REMS Capability Statement - REMS Administrator System](CapabilityStatement-rems-administrator-system.md)

### ImplementationGuides

* [US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG](index.md)

### Examples

* [example-rems-docref-1 (DocumentReference)](DocumentReference-example-rems-docref-1.md)
* [parameters-rems-etasu-input (Parameters)](Parameters-parameters-rems-etasu-input.md)
* [parameters-rems-etasu-output (Parameters)](Parameters-parameters-rems-etasu-output.md)
* [example-patient-123 (Patient)](Patient-example-patient-123.md)
* [pra1234 (Practitioner)](Practitioner-pra1234.md)
* [medication-rems-task-smart-launch-1 (Task)](Task-medication-rems-task-smart-launch-1.md)
