# Artifacts Summary - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Medication REMS Capability Statement - Provider System](CapabilityStatement-provider-system.md) | This CapabilityStatement describes the expected capabilities of a Provider System that conforms to the conventions of the Medication REMS FHIR implementation guide. |
| [Medication REMS Capability Statement - REMS Administrator System](CapabilityStatement-rems-administrator-system.md) | This CapabilityStatement describes the expected capabilities of a REMS Administrator System that conforms to the conventions of the Medication REMS FHIR implementation guide. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Medication REMS Task - SMART Launch](StructureDefinition-medication-rems-task-smart-launch.md) | This profile defines a Task to be returned in a REMS Administrator’s CDS Hooks response - enabling the provider or staff to launch a SMART app from their work queue. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [example-patient-123](Patient-example-patient-123.md) | Example of a US Core patient |
| [example-rems-docref-1](DocumentReference-example-rems-docref-1.md) | Example of a US Core document reference containing a patient’s REMS program information |
| [medication-rems-task-smart-launch-1](Task-medication-rems-task-smart-launch-1.md) | Complete patient enrollment using the DRUG-X REMS SMART app |
| [parameters-rems-etasu-input](Parameters-parameters-rems-etasu-input.md) | Example input parameters for the $rems-etasu operation |
| [parameters-rems-etasu-output](Parameters-parameters-rems-etasu-output.md) | Example output parameters for the $rems-etasu operation |
| [pra1234](Practitioner-pra1234.md) | Example of a Practitioner |

