# medication-rems-task-smart-launch-1 - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **medication-rems-task-smart-launch-1**

## Example Task: medication-rems-task-smart-launch-1

### Example data content

-------

Profile: [Medication REMS Task - SMART Launch](StructureDefinition-medication-rems-task-smart-launch.md)

**status**: Requested

**intent**: proposal

**code**: Launch application using the SMART EHR launch

**description**: Complete patient enrollment using the DRUG-X REMS SMART app

**for**: [August Samuels](Patient-example-patient-123.md)

**authoredOn**: 2024-02-13

> **input****type**:SMART on FHIR application URL.**value**:[https://example.org/DRUG-X/smart-application](https://example.org/DRUG-X/smart-application)

> **input****type**:Application context related to this launch.**value**: {"providerSystemPatientId":"123"}



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "medication-rems-task-smart-launch-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/medication-rems/StructureDefinition/medication-rems-task-smart-launch"
    ]
  },
  "status" : "requested",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
        "code" : "launch-app-ehr",
        "display" : "Launch application using the SMART EHR launch"
      }
    ]
  },
  "description" : "Complete patient enrollment using the DRUG-X REMS SMART app",
  "for" : {
    "reference" : "Patient/example-patient-123",
    "display" : "August Samuels"
  },
  "authoredOn" : "2024-02-13",
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
            "code" : "smartonfhir-application",
            "display" : "SMART on FHIR application URL."
          }
        ]
      },
      "valueUrl" : "https://example.org/DRUG-X/smart-application"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/smart-app-launch/CodeSystem/smart-codes",
            "code" : "smartonfhir-appcontext",
            "display" : "Application context related to this launch."
          }
        ]
      },
      "valueString" : "{\"providerSystemPatientId\":\"123\"}"
    }
  ]
}

```
