# Medication REMS Task - SMART Launch - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication REMS Task - SMART Launch**

## Resource Profile: Medication REMS Task - SMART Launch 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/medication-rems/StructureDefinition/medication-rems-task-smart-launch | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:MedicationRemsTaskSmartLaunch |

 
This profile defines a Task to be returned in a REMS Administrator’s CDS Hooks response - enabling the provider or staff to launch a SMART app from their work queue. 

**Important elements in this profile:**

* **Task.code** 
* The value, `launch-app-ehr` defines this task as one that places the specified SMART app in the provider’s work queue
 
* **Task.for** 
* Patient reference that SHOULD be populated if the requested use of the SMART app is related to a particular patient
 
* **Task.requester** 
* The organization requesting that this task be performed SHOULD be provided
 
* **Task.owner** 
* A reference to the provider in whose work queue to add the SMART app launch task SHOULD be populated
 
* **Task.reasonReference** 
* The medication request for the REMS drug that this task relates to SHALL be populated if this task is related to a specific prescription
 
* **Input.type =`smartonfhir-application`** 
* Indicates that this input holds the URL of the SMART app to be launched
 
* **Input.type =`smartonfhir-appcontext`** 
* Indicates that this input holds app context information to be used by the SMART application. This content will be included as `appContext` in the token response as is specified [here in the CDS Hooks specification](https://cds-hooks.org/specification/current/#link)
 

**Usages:**

* Examples for this Profile: [Task/medication-rems-task-smart-launch-1](Task-medication-rems-task-smart-launch-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.medication-rems|current/StructureDefinition/medication-rems-task-smart-launch)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication-rems-task-smart-launch.csv), [Excel](StructureDefinition-medication-rems-task-smart-launch.xlsx), [Schematron](StructureDefinition-medication-rems-task-smart-launch.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication-rems-task-smart-launch",
  "meta" : {
    "lastUpdated" : "2024-03-10T00:00:00-05:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/medication-rems/ImplementationGuide/hl7.fhir.us.medication-rems"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/medication-rems/ImplementationGuide/hl7.fhir.us.medication-rems"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/medication-rems/StructureDefinition/medication-rems-task-smart-launch",
  "version" : "2.0.0",
  "name" : "MedicationRemsTaskSmartLaunch",
  "title" : "Medication REMS Task - SMART Launch",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-03-10T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "frank.mckinney@pocp.com"
        },
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile defines a Task to be returned in a REMS Administrator's CDS Hooks response - enabling the provider or staff to launch a SMART app from their work queue.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/smart-app-launch/StructureDefinition/task-ehr-launch",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.id",
        "path" : "Task.id",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "fixedCode" : "proposal",
        "mustSupport" : true
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "label" : "Related Patient",
        "short" : "Related Patient in the provider system",
        "comment" : "SHOULD be populated if the requested use of the SMART app is related to a particular patient",
        "mustSupport" : true
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "comment" : "The organization requesting that this task be performed SHOULD be provided",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Organization"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "label" : "Provider",
        "short" : "Provider",
        "comment" : "The provider in whose work queue to add the SMART app launch task SHOULD be populated",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Practitioner"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.reasonReference",
        "path" : "Task.reasonReference",
        "label" : "Related medication request",
        "short" : "Related medication request",
        "definition" : "The medication request for the REMS drug that this task relates to SHALL be populated if this task is related to a specific prescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/MedicationRequest"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.reasonReference.reference",
        "path" : "Task.reasonReference.reference",
        "label" : "MedicationRequest reference",
        "short" : "MedicationRequest reference",
        "definition" : "Reference to the related MedicationRequest resource",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
