# pra1234 - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pra1234**

## Example Practitioner: pra1234

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU3.1.1/StructureDefinition-us-core-practitioner.html)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.2.0/NamingSystem-npi.html)/1122334455

**name**: Jane Betty Doe (Official)

**telecom**: ph: 555-873-1557, [jane.betty@myhospital.com](mailto:jane.betty@myhospital.com), fax: 555-123-4567

**address**: 840 Seneca St Buffalo NY 14210 (home)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "pra1234",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1122334455"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Doe",
      "given" : ["Jane", "Betty"],
      "prefix" : ["Dr."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-873-1557",
      "rank" : 1
    },
    {
      "system" : "email",
      "value" : "jane.betty@myhospital.com",
      "rank" : 2
    },
    {
      "system" : "fax",
      "value" : "555-123-4567",
      "rank" : 3
    }
  ],
  "address" : [
    {
      "use" : "home",
      "type" : "both",
      "line" : ["840 Seneca St"],
      "city" : "Buffalo",
      "state" : "NY",
      "postalCode" : "14210"
    }
  ]
}

```
