# parameters-rems-etasu-output - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **parameters-rems-etasu-output**

## Example Parameters: parameters-rems-etasu-output

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "parameters-rems-etasu-output",
  "parameter" : [
    {
      "name" : "rems-etasu",
      "resource" : {
        "resourceType" : "GuidanceResponse",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\">REMS ETASU GuidanceResponse</div></div>"
        },
        "contained" : [
          {
            "resourceType" : "Parameters",
            "id" : "etasuOutputParameters",
            "parameter" : [
              {
                "name" : "Patient Enrollment",
                "resource" : {
                  "resourceType" : "GuidanceResponse",
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\">Patient Enrollment GuidanceResponse</div></div>"
                  },
                  "moduleUri" : "https://example.com/",
                  "status" : "success",
                  "subject" : {
                    "reference" : "Patient/example-patient-123"
                  },
                  "note" : [
                    {
                      "text" : "Patient Enrollment"
                    }
                  ]
                }
              },
              {
                "name" : "Prescriber Enrollment",
                "resource" : {
                  "resourceType" : "GuidanceResponse",
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\">Prescriber Enrollment GuidanceResponse</div></div>"
                  },
                  "moduleUri" : "https://example.com/",
                  "status" : "success",
                  "subject" : {
                    "reference" : "Patient/example-patient-123"
                  },
                  "note" : [
                    {
                      "text" : "Prescriber Enrollment"
                    }
                  ]
                }
              },
              {
                "name" : "case_number",
                "valueString" : "a24e73e53b2"
              }
            ]
          }
        ],
        "moduleCanonical" : "https://example.com/",
        "status" : "success",
        "subject" : {
          "reference" : "Patient/example-patient-123"
        },
        "outputParameters" : {
          "reference" : "#etasuOutputParameters"
        }
      }
    }
  ]
}

```
