# parameters-rems-etasu-input - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **parameters-rems-etasu-input**

## Example Parameters: parameters-rems-etasu-input

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "parameters-rems-etasu-input",
  "parameter" : [
    {
      "name" : "patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "example-patient-123",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2025-04-10T01:10:26.457-04:00"
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\">August <b>Samuels</b></div><table class=\"hapiPropertyTable\"><tbody><tr><td>Identifier</td><td>0V843229061TB</td></tr><tr><td>Address</td><td><span>10023 Oakways Ln</span><br/><span>Concord </span><span>MA</span></td></tr><tr><td>Date of birth</td><td><span>12 March 1989</span></td></tr></tbody></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-medicare",
            "value" : "0V843229061TB"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Samuels",
            "given" : ["August"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1989-03-12",
        "address" : [
          {
            "use" : "home",
            "type" : "both",
            "line" : ["10023 Oakways Ln"],
            "city" : "Concord",
            "state" : "MA",
            "postalCode" : "01742"
          }
        ]
      }
    },
    {
      "name" : "medication",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "123-mr-IPledge-med",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\">iPledge Medication</div></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code" : "6064",
              "display" : "isotretinoin"
            },
            {
              "system" : "http://hl7.org/fhir/sid/ndc",
              "code" : "0245-0571-01"
            }
          ]
        }
      }
    }
  ]
}

```
