# example-rems-docref-1 - US Medication Risk Evaluation and Mitigation Strategies (REMS) FHIR IG v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **example-rems-docref-1**

## Example DocumentReference: example-rems-docref-1

### Example data content

[expand all](#)|[contract all](#)
DocumentReference

id@value:  example-rems-docref-1

metaprofile
@value:  http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference

textstatus
@value:  generated
div**REMS information for August Samuels**
On March 9, 2024
Patient Name: August Samuels
Patient REMS ID: 0354600
Patient enrollment status: Enrolled March 9, 2024
Prescriber Name: Mary Patel
Prescriber REMS ID: 0354035500 (NPI)
Medication: Zombify 10mg Tablet
Initial dispense authorization number: 30550221

status@value:  current

typecoding
system@value:  http://loinc.org
code@value:  51851-4
display@value:  Administrative note

text@value:  REMS administrative note

categorycoding
system@value:  http://loinc.org
code@value:  51851-4
display@value:  Administrative note

subjectreference
@value:  Patient/example-patient-123
display@value:  August Samuels

date@value:  2024-03-09T15:29:46+00:00

description@value:  REMS Patient Information Note

contentattachment
contentType@value:  text/plain
data@value:  UkVNUyBpbmZvcm1hdGlvbiBmb3IgQXVndXN0IFNhbXVlbHMgW3RleHQgdHJ1bmNhdGVkXQ==
title@value:  REMS information for August Samuels on March 9, 2024

formatsystem
@value:  http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode
code@value:  urn:ihe:iti:xds:2017:mimeTypeSufficient
display@value:  mimeType Sufficient

contextperiod
start@value:  2024-03-09T08:00:00+11:00

-------

**REMS information for August Samuels**

On March 9, 2024

Patient Name: August Samuels

Patient REMS ID: 0354600

Patient enrollment status: Enrolled March 9, 2024

Prescriber Name: Mary Patel

Prescriber REMS ID: 0354035500 (NPI)

Medication: Zombify 10mg Tablet

Initial dispense authorization number: 30550221



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "example-rems-docref-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
    ]
  },
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51851-4",
        "display" : "Administrative note"
      }
    ],
    "text" : "REMS administrative note"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "51851-4",
          "display" : "Administrative note"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example-patient-123",
    "display" : "August Samuels"
  },
  "date" : "2024-03-09T15:29:46Z",
  "description" : "REMS Patient Information Note",
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/plain",
        "data" : "UkVNUyBpbmZvcm1hdGlvbiBmb3IgQXVndXN0IFNhbXVlbHMgW3RleHQgdHJ1bmNhdGVkXQ==",
        "title" : "REMS information for August Samuels on March 9, 2024"
      },
      "format" : {
        "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
        "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
        "display" : "mimeType Sufficient"
      }
    }
  ],
  "context" : {
    "period" : {
      "start" : "2024-03-09T08:00:00+11:00"
    }
  }
}

```
