# Prior Authorization Questionnaire Use Case - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Background**](background.md)
* [**Use Cases**](use-cases.md)
* **Prior Authorization Questionnaire Use Case**

## Prior Authorization Questionnaire Use Case

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The inclusion and support of the Prior Authorization Questionnaire use case in this implementation guide is made possible by the thoughtful contribution of the Da Vinci member organizations.

The following links provide general background information about prior-authorization scenarios:

* [Prior Authorization and Pre-Claim Review Program Stats (cms.gov)](https://www.cms.gov/files/document/prior-authorization-and-pre-claim-review-program-statistics.pdf)
* [Prior Authorization for Certain Hospital Outpatient Department (OPD) Services | CMS](https://www.cms.gov/data-research/monitoring-programs/medicare-fee-service-compliance-programs/prior-authorization-and-pre-claim-review-initiatives/prior-authorization-certain-hospital-outpatient-department-opd-services)
* [Preauthorization and Notification Lists for Healthcare Providers - Humana](https://provider.humana.com/coverage-claims/prior-authorizations/prior-authorization-lists)

This topic is focused on how Clinical Quality Language (CQL) is used to support this use case.

### Data Flow

The questionnaire examples and associated libraries for population expressions in this IG are expected to be used in the following data flow:

1. DTR Launch:[Retrieving Launch Context Information](https://hl7.org/fhir/us/davinci-dtr/specification.html#retrieving-launch-context-information)
1. $questionnaire-package:[Retrieving Questionnaire Packages](https://hl7.org/fhir/us/davinci-dtr/specification.html#retrieving-questionnaire-packages)
1. Questionnaire Package Bundle(s):[DTRQuestionnairePackageBundle](https://hl7.org/fhir/us/davinci-dtr/StructureDefinition-DTR-QPackageBundle.html)
1. Questionnaire Pre-Population:[Pre-Populating Questionnaire Responses](https://hl7.org/fhir/us/davinci-dtr/specification.html#pre-populating-questionnaireresponses)
1. FHIR API Calls (resulting from questionnaire pre-population):[Retrieval of FHIR Resources](https://hl7.org/fhir/us/davinci-dtr/specification.html#retrieval-of-patient-fhir-resources-to-supply-to-cql-execution-engine)

As described in the [Documentation Templates and Rules (DTR)](https://hl7.org/fhir/us/davinci-dtr) implementation guide, the DTR process can be used for a broad range of use cases, including launching from a [Coverage Requirements Discovery (CRD)](https://hl7.org/fhir/us/davinci-dtr/usecases.html#relation-to-coverage-requirements-discovery-crd) response, as well as requesting documents as described in the [Relationship to Clinical Data Exchange](https://hl7.org/fhir/us/davinci-dtr/usecases.html#relation-to-clinical-data-exchange-cdex) topic.

This diagram is a simplification of the overall DTR [Overview Sequence Diagram](https://hl7.org/fhir/us/davinci-dtr/specification.html#overview). This diagram is focusing on the interactions from the perspective of Clinical Quality Language (CQL) authoring and evaluation.

[Structured Data Capture (SDC)](http://hl7.org/fhir/uv/sdc/STU3) documents the use of several extensions for supporting CQL-based calculation and form behavior within a Questionnaire in the [Form Behavior and Calculation](http://hl7.org/fhir/uv/sdc/STU3/behavior.html#calculations) topic.

In addition, the DTR specification provides additional guidance and conformance requirements on the use of CQL within DTR Questionnaires in the [Use of CQL](https://hl7.org/fhir/us/davinci-dtr/specification.html#use-of-cql) topic.

The content and questionnaires in this IG are expected to already have resolved the question of coverage determination, and are focused on a particular individual represented as a Patient. If prior authorization is not required then the DTR process will not occur.

Following the above data flow, there are two key contexts in which CQL expressions may be used to populate questionnaire responses:

1. On the provider side, during the population step of questionnaire processing in the DTR application.
1. On the provider side, as part of form behavior (e.g. enableWhen processing) while the form is being filled out (including the possibility that answers to questions change the available context and form behavior).

Note: Implementations of $questionnaire-package may pre-populate elements of the QuestionnaireResponse; however, how that pre-population occurs payer-side is out of scope from both the CRD and DTR perspectives.

#### CQL Processing to Pre-Populate the QuestionnaireResponse

As part of the process of filling out a DTR questionnaire, the DTR application may use CQL expressions specified in the Questionnaire to evaluate the context data to determine the initial value for items in the QuestionnaireResponse.

CQL used in this operation:

* Will have a Patient context specified as the id of the patient in the DTR launch context and referenced by the QuestionnaireResponse. This is declared as a parameter through the SDC [Launch Context](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaire-launchContext.html) extension. 
* For example, a Patient context specified in the DTR launch context will be correlated with an sdc-questionnaire-launchContext extension with a name of `patient` and a type of `Patient`, and thereby established as the [Patient context](https://cql.hl7.org/02-authorsguide.html#context) for the CQL expressions specified in the Questionnaire. It would be the responsibility of the DTR application to reconcile such launch contexts.
 
* May declare additional parameters through the SDC Launch Context extension. 
* For example, an Encounter context specified in the DTR launch context may be correlated with an `sdc-questionnaire-launchContext` extension with a name of `encounter` and a type of `Encounter`, and thereby passed as a named parameter to CQL expressions specified in the Questionnaire.
* Additionally, since the binding to the Questionnaire Launch Context ValueSet is extensible, a Coverage context specified in the DTR launch context may be correlated with an `sdc-questionnaire-launchContext` extension with a name of `PrimaryCoverage` and a type of `Coverage`, and thereby passed as a named parameter to CQL expressions specified in the Questionnaire.
 

Generally, the SDC [Initial Expression](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaire-initialExpression.html) extension will be used to pre-populate a given item in the QuestionnaireResponse. This is how CQL expressions are specified in the Questionnaire.

Additionally, the SDC [Item Population Context](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaire-itemPopulationContext.html) extension can be used with a CQL expression to provide context when populating group items (i.e. group items whose sub-items are populated with the values of sub-elements of a value with multiple elements (e.g. HumanName, Address, or BackboneElement)).

#### CQL Processing to Determine Form Behavior

While a user is filling out the answers to a questionnaire, the DTR application may use CQL expressions specified in the questionnaire to control form behavior (such as enableWhen logic or calculation logic).

