# Usage - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Authoring Documentation**](authoring.md)
* [**Patterns**](patterns.md)
* **Usage**

## Usage

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

To use these libraries in your implementation guide, include a reference to this implementation guide as an implementation guide dependency:

```
<dependsOn id="cql-us">
  <uri value="http://hl7.org/fhir/us/cql/ImplementationGuide/hl7.fhir.us.cql"/>
  <packageId value="hl7.fhir.us.cql"/>
  <version value="1.0.0-ballot"/>
</dependsOn>

```

#### USCore ModelInfo

Clinical Quality Language ([CQL](http://cql.hl7.org)) is a high-level, domain-specific language focused on clinical quality, and it is targeted at measure and decision support artifact authors. Additionally, the CQL specification provides a machine-readable canonical representation called Expression Logical Model ([ELM](https://cql.hl7.org/04-logicalspecification.html)), which is targeted at implementations, and designed to enable automated sharing of clinical knowledge.

To use CQL with USCore, [model information](https://cql.hl7.org/07-physicalrepresentation.html#data-model-references) must be provided to the implementation environment. The [USCore-ModelInfo](Library-USCore-ModelInfo.md) library provides this information for US Core. To use USCore, include a [using declaration](https://cql.hl7.org/02-authorsguide.html#data-models) as shown in the example below:

```
using USCore version '3.1.1'

```

