# Home - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cql/ImplementationGuide/hl7.fhir.us.cql | *Version*:1.0.0 | |
| *IG Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:CQLUSCommon |

### Introduction

This implementation guide contains architectural guidance and re-usable libraries that facilitate the use of [Clinical Quality Language (CQL)](http://cql.hl7.org) with FHIR in the US Realm, with an initial use case of Prior Authorization Support Questionnaires as described in the [DaVinci Documentation Templates and Rules (DTR)](https://hl7.org/fhir/us/davinci-dtr/) implementation guide. Much of the guidance and content presented here is built on work done in the quality measurement domain, including patterns established by measure developers as part of testing and developing quality measures for use with FHIR. These patterns have been generalized to support US Core as well as harmonized to be usable across use cases.

The content in this implementation guide is provided for reuse and proposed to help streamline implementation and development of CQL-based knowledge artifacts in the US Realm. The guidance here is published informative and the IG imposes no conformance expectations on systems that make use of it. However, the content in this implementation guide is still stable as of publication versions, and will use semantic versioning to communicate change impact across publication versions, as described in the [CRMI IG versioning](https://hl7.org/fhir/uv/crmi/artifact-lifecycle.html#artifact-versioning) topic.

### Scope of Use

This guide is a [Content Implementation Guide](https://hl7.org/fhir/uv/crmi/introduction.html#content-igs) that supports the use of CQL with FHIR in the US Realm by:

* Providing architectural guidance for the evaluation of CQL expressions in the context of artifacts such as questionnaires, quality measures, and decision support rules.
* Providing re-usable libraries of CQL expressions to retrieve data for common use cases in the US Realm
* Providing guidance for managing CQL expressions that may involve retrieval of data from multiple versions of the US Core implementation guide
* Gathering requirements for tooling to simplify the authoring of questionnaires that use CQL

The term [**artifact**](https://hl7.org/fhir/uv/crmi/index.html#artifacts) here refers to a FHIR resource that is definitional in nature or use such as a Questionnaire, or a Library (as opposed to a FHIR resource that is representing instance-specific data, such as an Observation). This implementation guide provides common artifacts that support the use of CQL with FHIR in the US Realm. The artifacts support a broad range of use cases across the healthcare domain, including prior-authorization, quality measurement and reporting, clinical decision support, computable guidelines, and public health case reporting. Any use of CQL within the US Realm could benefit from the artifacts provided here, as well as provide feedback to these artifacts, both in the form of proposed changes to existing artifacts, as well as proposing new artifacts that could be re-used across use cases.

Providing standardized CQL libraries will reduce burden by establishing best practices and reusable expressions for common questions across questionnaires, both currently and into the future. As well, these shared CQL artifacts will support a user with deep clinical knowledge but limited technical knowledge to be able to build and maintain CQL-based questionnaires. Open questionnaire authoring environments (i.e., LHC forms builder) exist and will enable the growth of CQL artifacts (see the [Tooling Support](tooling-support.md) page for further discussion).

> NOTE: Although the current guidance has been developed based on the prior-authorization questionnaires as the first use case, the intent is to capture common patterns, guidance, and artifacts that are usable across use-cases.

The artifacts provided by this implementation guide fall into three general categories:

1. Common CQL: Libraries of re-usable CQL expressions, such as US Core Common and US Core Elements, that are intended to be used in production systems as shared artifacts
1. Example Artifacts: Example content, such as the example Questionnaires, that are intended to illustrate how the shared artifacts may be used
1. Tests: Test content that demonstrates expected behavior of the CQL and Example artifacts

#### Out of Scope

This implementation guide does not:

* Define or mandate the use of any particular subsets of CQL
* Define functions for the retrieval of simple elements from already retrieved FHIR resources (e.g. Patient.birthDate)
* Define expectations for certification that require the use of any of the helper libraries provided in this implementation guide

### How to Read This Guide

#### Target Audiences

This implementation guide is targeted at two main audiences:

* **Authors**: Persons involved in the development of CQL-based FHIR Knowledge Artifacts that are authoring CQL, either directly or with tooling assistance
* **Integrators**: Persons involved in the development of systems that support authoring, publishing, distributing, and implementing CQL-based FHIR Knowledge Artifacts

This Guide is divided into several pages which are listed at the top of each page in the menu bar:

* **[Home](index.md)**
* **Background** 
* **[Background](background.md)**
* **[Use Cases](use-cases.md)**
 
* **Guidance** 
* **[Architectural Guidance](architectural-guidance.md)**
* **[Query Management](query-management.md)**
* **[Testing](testing.md)**
 
* **Authoring** 
* **[Authoring](authoring.md)**
* **[Patterns](patterns.md)**
* **[Examples](examples.md)**
* **[Usage](usage.md)**
* **[Tooling Support](tooling-support.md)**
 
* **CQL Artifacts** 
* **[US Core Common](Library-USCoreCommon.md)**
* **[US Core Elements](Library-USCoreElements.md)**
* **[US Core Model Information](uscore-modelinfo.md)**
* **[Cumulative Medication Duration](Library-CumulativeMedicationDuration.md)**
 
* **[FHIR Artifacts](artifacts.md)**
* **Support** 
* **[Downloads](downloads.md)**
* **[License](license.md)**
 
* **[Changes](changes.md)**

> NOTE: This implementation guide is informative, and therefore does not include a "Specification" topic like many other implementation guides do.

### Roadmap

Implementers of this content are encouraged to provide feedback through the usual mechanisms for feedback on HL7 FHIR Implementation Guides, by submitting an [issue](https://jira.hl7.org/secure/CreateIssueDetails!init.jspa?pid=10405&issuetype=10600&customfield_11302=FHIR-us-cql). To see the current status of the feedback for this specification, see the [US CQL Specification Dashboard](https://jira.hl7.org/secure/Dashboard.jspa?selectPageId=17807). For more information on how to submit feedback, refer to the [Specification Feedback](https://confluence.hl7.org/spaces/HL7/pages/19136736/Specification+Feedback) page in the HL7 confluence.

Feedback submitted to this implementation guide is discussed and resolved in the [Clinical Decision Support](https://confluence.hl7.org/spaces/CDS/pages/40742690/Meeting+Index) weekly meeting.

This implementation guide will be published for a two-year implementation period, during which time we will seek implementer feedback, applying as needed. The next ballot of this material will take place when the community indicates sufficient feedback and/or need for an updated release.

### Acknowledgements

This Implementation Guide was made possible by the thoughtful contributions of the following people and organizations:

* [The DaVinci Project Member Organizations](https://www.hl7.org/about/davinci/index.cfm?ref=common)
* Raj Godavarthi, MCG Health
* Mike Gould, Zeomega
* Yan Heras, Optimum eHealth
* Kyle Johnsen, Epic
* Crystal Kallem, Point of Care Partners
* Lloyd McKenzie, Dogwood Consulting
* Viet Nguyen, HL7
* Rob Reynolds, Smile Digital Health
* Brenin Rhodes, Smile Digital Health
* Bryn Rhodes, Smile Digital Health
* Raleigh Thompson, Smile Digital Health

### Dependencies

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.cql.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.cql.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CQLUSCommon](index.md), [CumulativeMedicationDuration](Library-CumulativeMedicationDuration.md)...Show 16 more,[CumulativeMedicationDurationTests](Library-CumulativeMedicationDurationTests.md),[ExamplePatientAndCoverageInitialExpressions](Library-ExamplePatientAndCoverageInitialExpressions.md),[ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md),[GMTPInitialExpressions](Library-GMTPInitialExpressions.md),[GMTPQuestionnaire](Questionnaire-GMTPQuestionnaire.md),[MBODAInitialExpressions](Library-MBODAInitialExpressions.md),[MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md),[MNACInitialExpressions](Library-MNACInitialExpressions.md),[MNACQuestionnaire](Questionnaire-MNACQuestionnaire.md),[UPPARFInitialExpressions](Library-UPPARFInitialExpressions.md),[UPPARFQuestionnaire](Questionnaire-UPPARFQuestionnaire.md),[USCore](Library-USCore-ModelInfo.md),[USCoreCommon](Library-USCoreCommon.md),[USCoreCommonTests](Library-USCoreCommonTests.md),[USCoreElements](Library-USCoreElements.md)and[USCoreTests](Library-USCoreTests.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md) and [MNACQuestionnaire](Questionnaire-MNACQuestionnaire.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [USCoreElements](Library-USCoreElements.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)
* [LibraryType](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html): [CumulativeMedicationDuration](Library-CumulativeMedicationDuration.md), [CumulativeMedicationDurationTests](Library-CumulativeMedicationDurationTests.md)...Show 10 more,[ExamplePatientAndCoverageInitialExpressions](Library-ExamplePatientAndCoverageInitialExpressions.md),[GMTPInitialExpressions](Library-GMTPInitialExpressions.md),[MBODAInitialExpressions](Library-MBODAInitialExpressions.md),[MNACInitialExpressions](Library-MNACInitialExpressions.md),[UPPARFInitialExpressions](Library-UPPARFInitialExpressions.md),[USCore](Library-USCore-ModelInfo.md),[USCoreCommon](Library-USCoreCommon.md),[USCoreCommonTests](Library-USCoreCommonTests.md),[USCoreElements](Library-USCoreElements.md)and[USCoreTests](Library-USCoreTests.md)
* [AdministrativeGender](http://terminology.hl7.org/6.5.0/CodeSystem-v3-AdministrativeGender.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)
* [NullFlavor](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)


Many of the examples in this implementation guide are informed by prior-authorization forms freely available on the internet and used with permission.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.cql",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://hl7.org/fhir/us/cql/ImplementationGuide/hl7.fhir.us.cql",
  "version" : "1.0.0",
  "name" : "CQLUSCommon",
  "title" : "Common CQL Artifacts for FHIR (US-Based)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-22T20:47:38+00:00",
  "publisher" : "HL7 International / Clinical Decision Support",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss"
        }
      ]
    }
  ],
  "description" : "This implementation guide contains architectural guidance and re-usable libraries that facilitate the use of Clinical Quality Language (CQL) with FHIR in the US Realm, with an initial use case of Prior Authorization Support Questionnaires as described in the DaVinci Documentation Templates and Rules (DTR) implementation guide. Much of the guidance and content presented here is built on work done in the quality measurement domain, including patterns established by measure developers as part of testing and developing quality measures for use with FHIR. These patterns have been generalized to support US Core as well as harmonized to be usable across use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.cql",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "cql",
      "uri" : "http://hl7.org/fhir/uv/cql/ImplementationGuide/hl7.fhir.uv.cql",
      "packageId" : "hl7.fhir.uv.cql",
      "version" : "2.0.0"
    },
    {
      "id" : "crmi",
      "uri" : "http://hl7.org/fhir/uv/crmi/ImplementationGuide/hl7.fhir.uv.crmi",
      "packageId" : "hl7.fhir.uv.crmi",
      "version" : "1.0.0"
    },
    {
      "id" : "sdc",
      "uri" : "http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc",
      "packageId" : "hl7.fhir.uv.sdc",
      "version" : "3.0.0"
    },
    {
      "id" : "uscore7",
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Informative 1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-binary"
          },
          {
            "url" : "value",
            "valueString" : "input/cql"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "resources/parameters/Parameters-manifest.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid-ig"
          },
          {
            "url" : "value",
            "valueString" : "templates\\liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-manifest"
          },
          {
            "url" : "value",
            "valueString" : "manifest"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/cql/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Informative 1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-binary"
          },
          {
            "url" : "value",
            "valueString" : "input/cql"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "resources/parameters/Parameters-manifest.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid-ig"
          },
          {
            "url" : "value",
            "valueString" : "templates\\liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-manifest"
          },
          {
            "url" : "value",
            "valueString" : "manifest"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/cql/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/uscore-7-0-0-modelinfo-settings"
        },
        "name" : "USCore700ModelInfoSettings",
        "description" : "US Core 7.0.0 Model Information Settings",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/manifest"
        },
        "name" : "Input Expansion Parameters",
        "description" : "The input expansion parameters resource for this implementation guide, specifying SNOMED Edition and version. This resource will be contained within the published implementation guide with all pinned references.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/CumulativeMedicationDuration"
        },
        "name" : "Cumulative Medication Duration",
        "description" : "This library provides cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources. The logic here follows the guidance provided as part of the 5.6 version of Quality Data Model."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/CumulativeMedicationDurationTests"
        },
        "name" : "Cumulative Medication Duration Tests",
        "description" : "This library provides tests for the cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/ExamplePatientAndCoverageInitialExpressions"
        },
        "name" : "Expression Library for the Example Patient And Coverage Questionnaire",
        "description" : "This library defines initial expressions for use in populating answers to questions in the Example Patient And Coverage questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/GMTPInitialExpressions"
        },
        "name" : "Expression Library for the Genetic/Molecular testing preauthorization Example",
        "description" : "Initial expressions for use in populating answers to questions in the Genetic/Molecular testing preauthorization example questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/MBODAInitialExpressions"
        },
        "name" : "Expression Library for the Medical Benefit Outpatient Drug Authorization Example",
        "description" : "Initial expressions for use in populating answers to questions in the Medical Benefit Outpatient Drug Authorization example questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/MNACInitialExpressions"
        },
        "name" : "Expression Library for the Medical Necessity For Authorization Of Catheters Example",
        "description" : "This library defines initial expressions for use in populating answers to questions in the Medical Necessity For Authorization Of Catheters example questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/UPPARFInitialExpressions"
        },
        "name" : "Expression Library for the Uniform Pharmacy Prior Authorization Request Form Example",
        "description" : "Initial expressions for use in populating answers to questions in the Example Uniform Pharmacy Prior Authorization Request Form example questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/USCore-ModelInfo"
        },
        "name" : "US Core Model Information",
        "description" : "CQL model information for the US Core version 7.0.0 implementation guide."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/USCoreCommon"
        },
        "name" : "US Core Common",
        "description" : "This library defines functions to expose extensions defined in USCore as fluent functions in CQL, as well as common terminology and functions used in writing CQL with FHIR and USCore profiles."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/USCoreCommonTests"
        },
        "name" : "US Core Common Tests",
        "description" : "Tests for the expressions and functions defined in the US Core Common library."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/USCoreElements"
        },
        "name" : "US Core Elements",
        "description" : "A library of expressions, functions, and terminology declarations for use with FHIR in the US Realm."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/USCoreTests"
        },
        "name" : "US Core Tests",
        "description" : "This is a testing library used to validate capability of the CQL-to-ELM translator using the US Core model info."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/ExamplePatientAndCoverageQuestionnaire"
        },
        "name" : "Example Patient and Coverage Questionnaire",
        "description" : "For the Prior Authorization Questionnaire Use Case, this type of in-context information is expected to be known already so it wouldn't typically be in a Questionnaire. This example illustrates how to get this information if it is needed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/GMTPQuestionnaire"
        },
        "name" : "Example Genetic/Molecular Testing Preauthorization Questionnaire",
        "description" : "This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/MBODAQuestionnaire"
        },
        "name" : "Example Medical Benefit Outpatient Drug Authorization Questionnaire",
        "description" : "This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/MNACQuestionnaire"
        },
        "name" : "Example Medical Necessity For Authorization Of Catheters Questionnaire",
        "description" : "This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/UPPARFQuestionnaire"
        },
        "name" : "Example Uniform Pharmacy Prior Authorization Request Form",
        "description" : "This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form."
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "use-cases.html"
                }
              ],
              "nameUrl" : "use-cases.html",
              "title" : "Use Cases",
              "generation" : "markdown",
              "page" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "use-case-pa.html"
                    }
                  ],
                  "nameUrl" : "use-case-pa.html",
                  "title" : "Prior Authorization Questionnaire Use Case",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "use-case-cqm.html"
                    }
                  ],
                  "nameUrl" : "use-case-cqm.html",
                  "title" : "Quality Measurement and Reporting",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "use-case-cds.html"
                    }
                  ],
                  "nameUrl" : "use-case-cds.html",
                  "title" : "Clinical Decision Support",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "use-case-cpg.html"
                    }
                  ],
                  "nameUrl" : "use-case-cpg.html",
                  "title" : "Clinical Guidelines",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "use-case-ph.html"
                    }
                  ],
                  "nameUrl" : "use-case-ph.html",
                  "title" : "Public Health Case Reporting",
                  "generation" : "markdown"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "architectural-guidance.html"
            }
          ],
          "nameUrl" : "architectural-guidance.html",
          "title" : "Architectural Guidance",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-management.html"
                }
              ],
              "nameUrl" : "query-management.html",
              "title" : "Query Management",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "testing.html"
                }
              ],
              "nameUrl" : "testing.html",
              "title" : "Testing",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authoring.html"
            }
          ],
          "nameUrl" : "authoring.html",
          "title" : "Authoring Documentation",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "patterns.html"
                }
              ],
              "nameUrl" : "patterns.html",
              "title" : "Patterns",
              "generation" : "markdown",
              "page" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-overall.html"
                    }
                  ],
                  "nameUrl" : "patterns-overall.html",
                  "title" : "Overall Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-allergy.html"
                    }
                  ],
                  "nameUrl" : "patterns-allergy.html",
                  "title" : "Allergy Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-condition.html"
                    }
                  ],
                  "nameUrl" : "patterns-condition.html",
                  "title" : "Condition Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-coverage.html"
                    }
                  ],
                  "nameUrl" : "patterns-coverage.html",
                  "title" : "Coverage Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-lab.html"
                    }
                  ],
                  "nameUrl" : "patterns-lab.html",
                  "title" : "Lab Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-medication.html"
                    }
                  ],
                  "nameUrl" : "patterns-medication.html",
                  "title" : "Medication Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-patient.html"
                    }
                  ],
                  "nameUrl" : "patterns-patient.html",
                  "title" : "Patient Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "patterns-service.html"
                    }
                  ],
                  "nameUrl" : "patterns-service.html",
                  "title" : "Service Patterns",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "examples.html"
                    }
                  ],
                  "nameUrl" : "examples.html",
                  "title" : "Examples",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "tooling-support.html"
                    }
                  ],
                  "nameUrl" : "tooling-support.html",
                  "title" : "Tooling Support",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "usage.html"
                    }
                  ],
                  "nameUrl" : "usage.html",
                  "title" : "Usage",
                  "generation" : "markdown"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                      "valueCode" : "informative"
                    },
                    {
                      "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                      "valueUrl" : "uscore-modelinfo.html"
                    }
                  ],
                  "nameUrl" : "uscore-modelinfo.html",
                  "title" : "US Core Model Information",
                  "generation" : "markdown"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "license.html"
            }
          ],
          "nameUrl" : "license.html",
          "title" : "License",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources/device"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources/library"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources/parameters"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources/questionnaire"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
