# Examples - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Authoring Documentation**](authoring.md)
* [**Patterns**](patterns.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Prior-Authorization Questionnaire Examples

This implementation guide includes several worked examples of prior authorization questionnaires:

* [Example Patient and Coverage Questionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md) 
For the Prior Authorization Questionnaire Use Case, this type of in-context information is expected to be known already so it wouldn't typically be in a Questionnaire. This example illustrates how to get this information if it is needed. 

* [Example Genetic/Molecular Testing Preauthorization Questionnaire](Questionnaire-GMTPQuestionnaire.md) 
This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. 

* [Example Medical Benefit Outpatient Drug Authorization Questionnaire](Questionnaire-MBODAQuestionnaire.md) 
This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. 

* [Example Medical Necessity For Authorization Of Catheters Questionnaire](Questionnaire-MNACQuestionnaire.md) 
This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. 

* [Example Uniform Pharmacy Prior Authorization Request Form](Questionnaire-UPPARFQuestionnaire.md) 
This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. 

The examples above are informed by freely available prior-authorization forms downloaded from Humana's prior authorization support portal and used with permission. These examples demonstrate the use of CQL expressions as part of the prior-authorization use case.

For information on how these examples can be tested, see the [Testing](testing.md) page in this implementation guide.

### Examples for Other Use Cases

Examples for other use cases are maintained as part of specifications detailing those use cases:

* [Quality Measure Examples](https://hl7.org/fhir/uv/cqm/examples.html)
* [Clinical Practice Guideline Examples](https://hl7.org/fhir/uv/cpg/examples.html)
* [Opioid Prescribing Support](https://build.fhir.org/ig/cqframework/opioid-cds-r4/)
* [Public Health Reporting](https://hl7.org/fhir/us/ecr/artifacts.html#12)

